/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.pipeline;

import com.mojang.logging.LogUtils;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.post.PostPipeline;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public final class VeilFirstPersonRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 FIRST_PERSON = new class_2960("veil", "first_person");
    private static PostPipeline pipeline;
    private static boolean printedError;

    private VeilFirstPersonRenderer() {
    }

    public static void setup() {
        VeilRenderer renderer = VeilRenderSystem.renderer();
        AdvancedFbo buffer = VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(VeilFramebuffers.FIRST_PERSON);
        pipeline = renderer.getPostProcessingManager().getPipeline(FIRST_PERSON);
        if (pipeline == null || buffer == null) {
            if (!printedError) {
                LOGGER.warn("Failed to render first person with pipeline: {}, {}", (Object)FIRST_PERSON, (Object)VeilFramebuffers.FIRST_PERSON);
                printedError = true;
            }
            return;
        }
        buffer.bind(false);
        printedError = false;
    }

    public static void blit() {
        if (pipeline != null) {
            VeilRenderSystem.renderer().getPostProcessingManager().runPipeline(pipeline);
        }
        AdvancedFbo.unbind();
    }
}

