/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.AreaLight;
import foundry.veil.api.client.render.deferred.light.DirectionalLight;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.LightRenderer;
import foundry.veil.api.client.render.deferred.light.PointLight;
import foundry.veil.api.client.render.deferred.light.PositionedLight;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImDouble;
import imgui.type.ImFloat;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LightEditor
extends SingleWindowEditor {
    private final Light.Type[] lightTypes = Light.Type.values();

    @Override
    public String getDisplayName() {
        return "Light Editor";
    }

    @Override
    public boolean isEnabled() {
        return VeilRenderSystem.renderer().getDeferredRenderer().isEnabled();
    }

    @Override
    protected void renderComponents() {
        LightRenderer lightRenderer = VeilRenderSystem.renderer().getDeferredRenderer().getLightRenderer();
        if (ImGui.button("Add Light")) {
            ImGui.openPopup("add_light_popup");
        }
        if (ImGui.isItemHovered(0)) {
            ImGui.setTooltip("Add a new light to the world");
        }
        for (Light.Type lightType : this.lightTypes) {
            List lights = lightRenderer.getLights(lightType);
            for (int i = 0; i < lights.size(); ++i) {
                ImGui.pushID("light" + i);
                LightEditor.renderLightComponents((Light)lights.get(i));
                ImGui.popID();
            }
        }
        if (ImGui.beginPopup("add_light_popup")) {
            ImGui.text("Choose Light Type:");
            for (Light.Type lightType : this.lightTypes) {
                PointLight light;
                if (!ImGui.selectable(lightType.name())) continue;
                class_4184 mainCamera = class_310.method_1551().field_1773.method_19418();
                switch (lightType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case POINT: {
                        Light light2 = new PointLight().setRadius(15.0f);
                        break;
                    }
                    case AREA: {
                        Light light2 = new AreaLight().setDistance(15.0f).setOrientation((Quaternionfc)new Quaternionf().lookAlong((Vector3fc)mainCamera.method_19335().mul(-1.0f), (Vector3fc)mainCamera.method_19336()));
                        break;
                    }
                    case DIRECTIONAL: {
                        Light light2 = light = new DirectionalLight().setDirection(0.0f, -1.0f, 0.0f);
                    }
                }
                if (light instanceof PositionedLight) {
                    PositionedLight positionedLight = light;
                    class_243 cameraPos = mainCamera.method_19326();
                    positionedLight.setPosition(cameraPos.method_10216(), cameraPos.method_10214(), cameraPos.method_10215());
                }
                lightRenderer.addLight(((Light)light).setColor(1.0f, 1.0f, 1.0f).setBrightness(1.0f));
            }
            ImGui.endPopup();
        }
    }

    private static void renderLightComponents(Light light) {
        LightRenderer lightRenderer = VeilRenderSystem.renderer().getDeferredRenderer().getLightRenderer();
        ImBoolean notDeleted = new ImBoolean(true);
        if (ImGui.collapsingHeader(light.getType().name() + "#" + light.hashCode(), notDeleted)) {
            LightEditor.renderLightAttributeComponents(light);
        }
        if (!notDeleted.get()) {
            lightRenderer.removeLight(light);
        }
        ImGui.separator();
    }

    private static void renderLightAttributeComponents(Light light) {
        Vector3fc lightColor = light.getColor();
        ImFloat editBrightness = new ImFloat(light.getBrightness());
        float[] editLightColor = new float[]{lightColor.x(), lightColor.y(), lightColor.z()};
        ImGui.indent();
        if (ImGui.dragScalar("##brightness", 8, editBrightness, 0.02f)) {
            light.setBrightness(editBrightness.get());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("brightness");
        if (ImGui.colorPicker3("##color", editLightColor)) {
            light.setColor(editLightColor[0], editLightColor[1], editLightColor[2]);
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("color");
        ImGui.newLine();
        switch (light.getType()) {
            case POINT: {
                LightEditor.renderPointLightAttributeComponents((PointLight)light);
                break;
            }
            case AREA: {
                LightEditor.renderAreaLightAttributeComponents((AreaLight)light);
                break;
            }
            case DIRECTIONAL: {
                LightEditor.renderDirectionalLightAttributeComponents((DirectionalLight)light);
            }
        }
        ImGui.unindent();
    }

    private static void renderPointLightAttributeComponents(PointLight light) {
        Vector3d position = light.getPosition();
        ImDouble editX = new ImDouble(position.x());
        ImDouble editY = new ImDouble(position.y());
        ImDouble editZ = new ImDouble(position.z());
        ImFloat editRadius = new ImFloat(light.getRadius());
        float totalWidth = ImGui.calcItemWidth();
        ImGui.pushItemWidth(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f);
        if (ImGui.dragScalar("##x", 9, editX, 0.02f)) {
            light.setPosition(editX.get(), position.y(), position.z());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##y", 9, editY, 0.02f)) {
            light.setPosition(position.x(), editY.get(), position.z());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##z", 9, editZ, 0.02f)) {
            light.setPosition(position.x(), position.y(), editZ.get());
        }
        ImGui.popItemWidth();
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("position");
        if (ImGui.dragScalar("##radius", 8, editRadius, 0.02f, 0.0f)) {
            light.setRadius(editRadius.get());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("radius");
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("falloff");
    }

    private static void renderAreaLightAttributeComponents(AreaLight light) {
        Vector2f size = light.getSize();
        Vector3d position = light.getPosition();
        Vector3f orientationAngles = light.getOrientation().getEulerAnglesXYZ(new Vector3f());
        float[] editSize = new float[]{size.x(), size.y()};
        ImDouble editX = new ImDouble(position.x());
        ImDouble editY = new ImDouble(position.y());
        ImDouble editZ = new ImDouble(position.z());
        ImFloat editXRot = new ImFloat(orientationAngles.x() * 57.295776f);
        ImFloat editYRot = new ImFloat(orientationAngles.y() * 57.295776f);
        ImFloat editZRot = new ImFloat(orientationAngles.z() * 57.295776f);
        ImFloat editAngle = new ImFloat(light.getAngle() * 57.295776f);
        ImFloat editDistance = new ImFloat(light.getDistance());
        if (ImGui.dragFloat2("##size", editSize, 0.02f, 1.0E-4f)) {
            light.setSize(editSize[0], editSize[1]);
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("size");
        float totalWidth = ImGui.calcItemWidth();
        ImGui.pushItemWidth(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f);
        if (ImGui.dragScalar("##x", 9, editX, 0.02f)) {
            light.setPosition(editX.get(), position.y(), position.z());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##y", 9, editY, 0.02f)) {
            light.setPosition(position.x(), editY.get(), position.z());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##z", 9, editZ, 0.02f)) {
            light.setPosition(position.x(), position.y(), editZ.get());
        }
        ImGui.popItemWidth();
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("position");
        ImGui.pushItemWidth(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f);
        if (ImGui.dragScalar("##xrot", 8, editXRot, 0.2f)) {
            light.setOrientation((Quaternionfc)new Quaternionf().rotationXYZ(editXRot.get() * ((float)Math.PI / 180), orientationAngles.y(), orientationAngles.z()));
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##yrot", 8, editYRot, 0.2f)) {
            light.setOrientation((Quaternionfc)new Quaternionf().rotationXYZ(orientationAngles.x(), editYRot.get() * ((float)Math.PI / 180), orientationAngles.z()));
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar("##zrot", 8, editZRot, 0.2f)) {
            light.setOrientation((Quaternionfc)new Quaternionf().rotationXYZ(orientationAngles.x(), orientationAngles.y(), editZRot.get() * ((float)Math.PI / 180)));
        }
        ImGui.popItemWidth();
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("orientation");
        if (ImGui.dragScalar("##angle", 8, editAngle, 0.02f, 0.0f, 180.0f)) {
            light.setAngle(editAngle.get() * ((float)Math.PI / 180));
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("angle");
        if (ImGui.dragScalar("##distance", 8, editDistance, 0.02f, 0.0f)) {
            light.setDistance(editDistance.get());
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("distance");
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("falloff");
    }

    private static void renderDirectionalLightAttributeComponents(DirectionalLight light) {
        Vector3f vector;
        Vector3fc direction = light.getDirection();
        float[] editDirection = new float[]{direction.x(), direction.y(), direction.z()};
        if (ImGui.dragFloat3("##direction", editDirection, 0.005f) && !Float.isNaN((vector = new Vector3f(editDirection).normalize()).x()) && !Float.isNaN(vector.y()) && !Float.isNaN(vector.z())) {
            light.setDirection(editDirection[0], editDirection[1], editDirection[2]);
        }
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text("direction");
    }
}

