/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilVanillaShaders;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.quasar.particle.ParticleEmitter;
import foundry.veil.api.quasar.particle.ParticleSystemManager;
import foundry.veil.fabric.util.FabricReloadListener;
import foundry.veil.impl.client.render.VeilUITooltipRenderer;
import foundry.veil.util.VeilJsonListeners;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2232;
import net.minecraft.class_2277;
import net.minecraft.class_2280;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VeilFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        VeilClient.init();
        HudRenderCallback.EVENT.register((matrices, tickDelta) -> {
            class_310 client = class_310.method_1551();
            VeilUITooltipRenderer.renderOverlay(client.field_1705, matrices, tickDelta, client.method_22683().method_4486(), client.method_22683().method_4502());
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> VeilClient.tickClient(client.method_1488()));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> client.execute(() -> VeilRenderSystem.renderer().getDeferredRenderer().reset()));
        KeyBindingHelper.registerKeyBinding((class_304)VeilClient.EDITOR_KEY);
        FabricLoader loader = FabricLoader.getInstance();
        ModContainer container = (ModContainer)loader.getModContainer("veil").orElseThrow();
        if (Veil.DEBUG && loader.isDevelopmentEnvironment()) {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Veil.veilPath("test_shaders"), (ModContainer)container, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Veil.veilPath("test_particles"), (ModContainer)container, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        }
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)VeilDeferredRenderer.PACK_ID, (ModContainer)container, (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        CoreShaderRegistrationCallback.EVENT.register(context -> VeilVanillaShaders.registerShaders((arg_0, arg_1, arg_2) -> ((CoreShaderRegistrationCallback.RegistrationContext)context).register(arg_0, arg_1, arg_2)));
        VeilJsonListeners.registerListeners((type, id, listener) -> ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new FabricReloadListener(Veil.veilPath(id), listener)));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> {
            LiteralArgumentBuilder builder = LiteralArgumentBuilder.literal((String)"quasar");
            builder.then(ClientCommandManager.argument((String)"emitter", (ArgumentType)class_2232.method_9441()).suggests(QuasarParticles.emitterSuggestionProvider()).then(ClientCommandManager.argument((String)"position", (ArgumentType)class_2277.method_9737()).executes(ctx -> {
                class_2960 id = (class_2960)ctx.getArgument("emitter", class_2960.class);
                FabricClientCommandSource source = (FabricClientCommandSource)ctx.getSource();
                ParticleSystemManager particleManager = VeilRenderSystem.renderer().getParticleManager();
                ParticleEmitter instance = particleManager.createEmitter(id);
                if (instance == null) {
                    source.sendError((class_2561)class_2561.method_43470((String)("Unknown emitter: " + id)));
                    return 0;
                }
                class_2280 pos = (class_2280)ctx.getArgument("position", class_2280.class);
                instance.setPosition(pos.method_9708(source.getEntity().method_5671()));
                particleManager.addParticleSystem(instance);
                source.sendFeedback((class_2561)class_2561.method_43470((String)("Spawned " + id)));
                return 1;
            })));
            dispatcher.register(builder);
        });
        ClientTickEvents.START_WORLD_TICK.register(client -> VeilRenderSystem.renderer().getParticleManager().tick());
    }
}

