/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderType;
import foundry.veil.api.quasar.data.QuasarParticleData;
import foundry.veil.api.quasar.fx.Trail;
import foundry.veil.api.quasar.particle.QuasarParticle;
import foundry.veil.api.quasar.particle.SpriteData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4fc;

public class RenderData {
    @Deprecated
    private static final class_2960 BLANK = Veil.veilPath("textures/special/blank.png");
    private static final Vector3fc[] PLANE_POSITIONS = new Vector3fc[]{new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)};
    private static final Vector3fc[] CUBE_POSITIONS = new Vector3fc[]{new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(1.0f, -1.0f, -1.0f)};
    private final Vector3d prevPosition = new Vector3d();
    private final Vector3d renderPosition = new Vector3d();
    private final Vector3f prevRotation = new Vector3f();
    private final Vector3f renderRotation = new Vector3f();
    private float prevRadius = 1.0f;
    private float renderRadius = 1.0f;
    private int lightColor = 0xF000F0;
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private float alpha = 1.0f;
    public float renderAge = 0.0f;
    public float agePercent;
    private SpriteData spriteData = null;
    private class_1058 atlasSprite = null;
    private class_1921 renderType;
    private final List<Trail> trails;

    public RenderData() {
        this.updateRenderType();
        this.trails = new ArrayList<Trail>();
    }

    private void updateRenderType() {
        this.renderType = this.atlasSprite != null ? VeilRenderType.quasarParticle(this.atlasSprite.method_45852()) : (this.spriteData != null ? VeilRenderType.quasarParticle(this.spriteData.sprite()) : VeilRenderType.quasarParticle(BLANK));
    }

    @ApiStatus.Internal
    public void tick(QuasarParticle particle, int lightColor) {
        this.prevPosition.set((Vector3dc)particle.getPosition());
        this.prevRotation.set((Vector3fc)particle.getRotation());
        this.prevRadius = particle.getRadius();
        this.lightColor = lightColor;
    }

    @ApiStatus.Internal
    public void render(QuasarParticle particle, float partialTicks) {
        this.prevPosition.lerp((Vector3dc)particle.getPosition(), (double)partialTicks, this.renderPosition);
        this.prevRotation.lerp((Vector3fc)particle.getRotation(), partialTicks, this.renderRotation);
        this.renderRadius = class_3532.method_16439((float)partialTicks, (float)this.prevRadius, (float)particle.getRadius());
        this.renderAge = (float)particle.getAge() + partialTicks;
        this.agePercent = Math.min(this.renderAge / (float)particle.getLifetime(), 1.0f);
    }

    public Vector3dc getRenderPosition() {
        return this.renderPosition;
    }

    public Vector3fc getRenderRotation() {
        return this.renderRotation;
    }

    public float getRenderRadius() {
        return this.renderRadius;
    }

    public float getRenderAge() {
        return this.renderAge;
    }

    public float getAgePercent() {
        return this.agePercent;
    }

    public int getLightColor() {
        return this.lightColor;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Nullable
    public SpriteData getSpriteData() {
        return this.spriteData;
    }

    public class_1058 getAtlasSprite() {
        return this.atlasSprite;
    }

    public class_1921 getRenderType() {
        return this.renderType;
    }

    public List<Trail> getTrails() {
        return this.trails;
    }

    public void renderTrails(class_4587 poseStack, class_4597 bufferSource, class_243 cameraPos, int packedLight) {
        if (this.trails.isEmpty()) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
        for (Trail trail : this.trails) {
            trail.pushRotatedPoint(new class_243(this.prevPosition.x, this.prevPosition.y, this.prevPosition.z), new class_243((double)this.prevRotation.x, (double)this.prevRotation.y, (double)this.prevRotation.z));
            trail.render(poseStack, bufferSource.getBuffer(VeilRenderType.quasarTrail(trail.getTexture())), packedLight);
        }
        poseStack.method_22909();
    }

    public void setRed(float red) {
        this.red = red;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setColor(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public void setColor(Vector4fc color) {
        this.red = color.x();
        this.green = color.y();
        this.blue = color.z();
        this.alpha = color.w();
    }

    public void setSpriteData(@Nullable SpriteData spriteData) {
        this.spriteData = spriteData;
        this.updateRenderType();
    }

    public void setAtlasSprite(@Nullable class_1058 atlasSprite) {
        this.atlasSprite = atlasSprite;
        this.updateRenderType();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum RenderStyle {
        CUBE{

            @Override
            public void render(class_4587 poseStack, QuasarParticle particle, RenderData renderData, Vector3fc renderOffset, class_4588 builder, double ageModifier, float partialTicks) {
                Matrix4f matrix4f = poseStack.method_23760().method_23761();
                Vector3fc rotation = renderData.getRenderRotation();
                Vector3f vec = new Vector3f();
                for (int i = 0; i < 6; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        vec.set(CUBE_POSITIONS[i * 4 + j]);
                        QuasarParticleData data = particle.getData();
                        if (vec.z < 0.0f && data.velocityStretchFactor() != 0.0f) {
                            vec.z *= 1.0f + data.velocityStretchFactor();
                        }
                        vec.rotateX(rotation.x()).rotateY(rotation.y()).rotateZ(rotation.z()).mul((float)((double)renderData.getRenderRadius() * ageModifier)).add(renderOffset);
                        builder.method_22918(matrix4f, vec.x, vec.y, vec.z);
                        builder.method_22913((float)j / 2.0f, (float)(j % 2));
                        builder.method_22915(renderData.getRed(), renderData.getGreen(), renderData.getBlue(), renderData.getAlpha());
                        builder.method_22916(renderData.getLightColor());
                        builder.method_1344();
                    }
                }
            }
        }
        ,
        BILLBOARD{

            @Override
            public void render(class_4587 poseStack, QuasarParticle particle, RenderData renderData, Vector3fc renderOffset, class_4588 builder, double ageModifier, float partialTicks) {
                Matrix4f matrix4f = poseStack.method_23760().method_23761();
                Vector3fc rotation = renderData.getRenderRotation();
                Quaternionf faceCameraRotation = class_310.method_1551().method_1561().method_24197();
                SpriteData spriteData = renderData.getSpriteData();
                int red = (int)(renderData.getRed() * 255.0f) & 0xFF;
                int green = (int)(renderData.getGreen() * 255.0f) & 0xFF;
                int blue = (int)(renderData.getBlue() * 255.0f) & 0xFF;
                int alpha = (int)(renderData.getAlpha() * 255.0f) & 0xFF;
                Vector3f vec = new Vector3f();
                for (int j = 0; j < 4; ++j) {
                    float v;
                    float u;
                    vec.set(PLANE_POSITIONS[j]);
                    if (particle.getData().velocityStretchFactor() > 0.0f) {
                        vec.set(vec.x * (1.0f + particle.getData().velocityStretchFactor()), vec.y, vec.z);
                    }
                    if (particle.getData().faceVelocity()) {
                        vec.rotateX(rotation.x()).rotateY(rotation.y()).rotateZ(rotation.z());
                    }
                    faceCameraRotation.transform(vec).mul((float)((double)renderData.getRenderRadius() * ageModifier)).add(renderOffset);
                    if (j == 0) {
                        u = 0.0f;
                        v = 0.0f;
                    } else if (j == 1) {
                        u = 1.0f;
                        v = 0.0f;
                    } else if (j == 2) {
                        u = 1.0f;
                        v = 1.0f;
                    } else {
                        u = 0.0f;
                        v = 1.0f;
                    }
                    if (spriteData != null) {
                        int spritesheetRows = spriteData.frameHeight();
                        int spritesheetColumns = spriteData.frameWidth();
                        int spriteCount = spriteData.frameCount();
                        float animationSpeed = spriteData.frameTime();
                        int frameIndex = (int)(renderData.getRenderAge() / animationSpeed);
                        int frameIndexInSpritesheet = frameIndex % spriteCount;
                        int frameRow = frameIndexInSpritesheet / spritesheetColumns;
                        int frameColumn = frameIndexInSpritesheet % spritesheetColumns;
                        u *= 1.0f / (float)spritesheetColumns + (float)frameColumn * (1.0f / (float)spritesheetColumns);
                        v *= 1.0f / (float)spritesheetRows + (float)frameRow * (1.0f / (float)spritesheetRows);
                    }
                    builder.method_22918(matrix4f, vec.x, vec.y, vec.z);
                    builder.method_22913(u, v);
                    builder.method_1336(red, green, blue, alpha);
                    builder.method_22916(renderData.getLightColor());
                    builder.method_1344();
                }
            }
        };

        private static final Map<String, RenderStyle> VALUES;
        public static final Codec<RenderStyle> CODEC;

        public abstract void render(class_4587 var1, QuasarParticle var2, RenderData var3, Vector3fc var4, class_4588 var5, double var6, float var8);

        static {
            VALUES = Arrays.stream(RenderStyle.values()).collect(Collectors.toMap(v -> v.name().toLowerCase(Locale.ROOT), v -> v));
            CODEC = Codec.STRING.flatXmap(name -> {
                String key = name.toLowerCase(Locale.ROOT);
                RenderStyle renderStyle = VALUES.get(key);
                if (renderStyle == null) {
                    return DataResult.error(() -> "Invalid Render Style: " + key);
                }
                return DataResult.success((Object)((Object)renderStyle));
            }, style -> DataResult.success((Object)style.name().toLowerCase(Locale.ROOT)));
        }
    }
}

