/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.particle;

import com.mojang.logging.LogUtils;
import foundry.veil.api.TickTaskScheduler;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.quasar.data.ParticleEmitterData;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.quasar.particle.ParticleEmitter;
import foundry.veil.impl.TickTaskSchedulerImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.slf4j.Logger;

public class ParticleSystemManager {
    private static final int MAX_PARTICLES = 10000;
    private static final double PERSISTENT_DISTANCE_SQ = 1024.0;
    private static final double REMOVAL_DISTANCE_SQ = 16384.0;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<ParticleEmitter> particleEmitters = new ArrayList<ParticleEmitter>();
    private int particleCount = 0;
    private class_638 level = null;
    private TickTaskSchedulerImpl scheduler;

    @ApiStatus.Internal
    public void setLevel(@Nullable class_638 level) {
        this.clear();
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        this.level = level;
        this.scheduler = new TickTaskSchedulerImpl();
    }

    @Nullable
    public ParticleEmitter createEmitter(class_2960 name) {
        if (this.level == null) {
            return null;
        }
        ParticleEmitterData data = (ParticleEmitterData)QuasarParticles.registryAccess().method_30530(QuasarParticles.EMITTER).method_10223(name);
        if (data == null) {
            LOGGER.error("Unknown Quasar Particle Emitter: {}", (Object)name);
            return null;
        }
        return new ParticleEmitter(this, this.level, data);
    }

    public void addParticleSystem(ParticleEmitter particleEmitter) {
        this.scheduler.execute(() -> this.particleEmitters.add(particleEmitter));
    }

    public void clear() {
        for (ParticleEmitter particleEmitter : this.particleEmitters) {
            particleEmitter.onRemoved();
        }
        this.particleEmitters.clear();
    }

    @ApiStatus.Internal
    public void tick() {
        if (this.level == null) {
            return;
        }
        this.scheduler.run();
        Iterator<ParticleEmitter> iterator = this.particleEmitters.iterator();
        while (iterator.hasNext()) {
            ParticleEmitter emitter = iterator.next();
            emitter.tick();
            if (!emitter.isRemoved()) continue;
            emitter.onRemoved();
            iterator.remove();
        }
        this.particleCount = this.particleEmitters.stream().mapToInt(ParticleEmitter::getParticleCount).sum();
    }

    @ApiStatus.Internal
    public void render(class_4587 poseStack, class_4597 bufferSource, class_4184 camera, CullFrustum frustum, float partialTicks) {
        for (ParticleEmitter emitter : this.particleEmitters) {
            emitter.render(poseStack, bufferSource, camera, partialTicks);
        }
    }

    public void reserve(int particles) {
        int freeSpace = 10000 - this.particleCount;
        this.particleCount -= particles;
        if (particles <= freeSpace) {
            return;
        }
        particles -= freeSpace;
        class_1297 cameraEntity = class_310.method_1551().field_1719;
        for (ParticleEmitter emitter : this.particleEmitters) {
            Vector3d pos = emitter.getPosition();
            double d = cameraEntity != null ? (cameraEntity.method_5649(pos.x, pos.y, pos.z) - 1024.0) / 16384.0 : 1.0;
            double scaleFactor = Math.min(d, 1.0);
            if (!(scaleFactor > 0.0) || (particles -= emitter.trim(Math.min(particles, class_3532.method_15384((double)((double)emitter.getParticleCount() * scaleFactor))))) > 0) continue;
            break;
        }
    }

    public class_638 getLevel() {
        return this.level;
    }

    public TickTaskScheduler getScheduler() {
        return this.scheduler;
    }

    public int getEmitterCount() {
        return this.particleEmitters.size();
    }

    public int getParticleCount() {
        return this.particleCount;
    }
}

