/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.particle;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import foundry.veil.api.TickTaskScheduler;
import foundry.veil.api.quasar.data.EmitterSettings;
import foundry.veil.api.quasar.data.ParticleEmitterData;
import foundry.veil.api.quasar.data.QuasarParticleData;
import foundry.veil.api.quasar.data.module.ParticleModuleData;
import foundry.veil.api.quasar.emitters.module.update.FaceVelocityModule;
import foundry.veil.api.quasar.particle.ParticleModuleSet;
import foundry.veil.api.quasar.particle.ParticleSystemManager;
import foundry.veil.api.quasar.particle.QuasarParticle;
import foundry.veil.api.quasar.particle.RenderData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;

public class ParticleEmitter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<class_6880<ParticleModuleData>> REPORTED_MODULES = new HashSet<class_6880<ParticleModuleData>>();
    private final ParticleSystemManager particleManager;
    private final class_638 level;
    private final ParticleEmitterData emitterData;
    private final List<class_6880<ParticleModuleData>> modules;
    private final class_5819 randomSource;
    private final Vector3d position;
    private final List<QuasarParticle> particles;
    @Nullable
    private class_1297 attachedEntity;
    private CompletableFuture<?> spawnTask;
    private CompletableFuture<?> removeTask;
    private boolean removed;

    ParticleEmitter(ParticleSystemManager particleManager, class_638 level, ParticleEmitterData data) {
        this.particleManager = particleManager;
        this.level = level;
        this.emitterData = data;
        this.modules = ParticleEmitter.createModuleSet(data.particleData());
        this.randomSource = class_5819.method_43047();
        this.position = new Vector3d();
        this.particles = new ArrayList<QuasarParticle>();
        TickTaskScheduler scheduler = particleManager.getScheduler();
        this.spawnTask = scheduler.scheduleAtFixedRate(this::spawn, 0, data.rate());
        this.reset();
    }

    @ApiStatus.Internal
    public static void clearErrors() {
        REPORTED_MODULES.clear();
    }

    private void spawn() {
        int count = Math.min(this.emitterData.maxParticles(), this.emitterData.count());
        this.particleManager.reserve(count);
        for (int i = 0; i < count; ++i) {
            EmitterSettings emitterSettings = this.emitterData.emitterSettings();
            Vector3d particlePos = emitterSettings.emitterShapeSettings().getPos(this.randomSource, (Vector3dc)this.position);
            Vector3f particleDirection = emitterSettings.particleSettings().particleDirection(this.randomSource);
            ParticleModuleSet.Builder builder = ParticleModuleSet.builder();
            for (class_6880<ParticleModuleData> module : this.modules) {
                ((ParticleModuleData)module.comp_349()).addModules(builder);
            }
            if (this.emitterData.particleData().faceVelocity()) {
                builder.addModule(new FaceVelocityModule());
            }
            QuasarParticle particle = new QuasarParticle(this.level, this.randomSource, this.particleManager.getScheduler(), this.emitterData.particleData(), builder.build(), this.emitterData.emitterSettings().particleSettings(), this);
            particle.getPosition().set((Vector3dc)particlePos);
            particle.getVelocity().set((Vector3fc)particleDirection);
            particle.init();
            this.particles.add(particle);
        }
    }

    private static List<class_6880<ParticleModuleData>> createModuleSet(QuasarParticleData data) {
        ImmutableList.Builder builder = ImmutableList.builder();
        data.allModules().forEach(module -> {
            if (!module.method_40227()) {
                if (REPORTED_MODULES.add((class_6880<ParticleModuleData>)module)) {
                    String string;
                    if (module instanceof class_6880.class_6883) {
                        class_6880.class_6883 ref = (class_6880.class_6883)module;
                        string = ref.method_40237().method_29177();
                    } else {
                        string = module.getClass().getName();
                    }
                    LOGGER.error("Unknown module: {}", (Object)string);
                }
                return;
            }
            builder.add(module);
        });
        return builder.build();
    }

    private void expire() {
        if (this.emitterData.loop()) {
            this.reset();
        } else {
            this.remove();
        }
    }

    private void cancelTasks() {
        if (this.spawnTask != null) {
            this.spawnTask.cancel(false);
            this.spawnTask = null;
        }
        if (this.removeTask != null) {
            this.removeTask.cancel(false);
            this.removeTask = null;
        }
    }

    public void tick() {
        if (this.attachedEntity != null) {
            if (this.attachedEntity.method_5805()) {
                class_243 pos = this.attachedEntity.method_19538();
                this.position.set(pos.field_1352, pos.field_1351, pos.field_1350);
            } else {
                this.attachedEntity = null;
                this.remove();
            }
        }
        Iterator<QuasarParticle> iterator = this.particles.iterator();
        while (iterator.hasNext()) {
            QuasarParticle particle = iterator.next();
            particle.tick();
            if (!particle.isRemoved()) continue;
            iterator.remove();
            particle.onRemove();
        }
    }

    @ApiStatus.Internal
    public void render(class_4587 poseStack, class_4597 bufferSource, class_4184 camera, float partialTicks) {
        class_243 projectedView = camera.method_19326();
        QuasarParticleData particleData = this.emitterData.particleData();
        RenderData.RenderStyle renderStyle = particleData.renderStyle();
        Vector3f renderOffset = new Vector3f();
        class_1921 lastRenderType = null;
        class_4588 builder = null;
        for (QuasarParticle particle : this.particles) {
            RenderData renderData = particle.getRenderData();
            particle.render(partialTicks);
            renderData.renderTrails(poseStack, bufferSource, projectedView, 0xF000F0);
            Vector3dc renderPosition = renderData.getRenderPosition();
            renderOffset.set((float)(renderPosition.x() - projectedView.method_10216()), (float)(renderPosition.y() - projectedView.method_10214()), (float)(renderPosition.z() - projectedView.method_10215()));
            class_1921 renderType = renderData.getRenderType();
            if (!renderType.equals(lastRenderType)) {
                lastRenderType = renderType;
                builder = bufferSource.getBuffer(renderType);
                class_1058 sprite = renderData.getAtlasSprite();
                if (sprite != null) {
                    builder = sprite.method_24108(builder);
                }
            }
            renderStyle.render(poseStack, particle, renderData, (Vector3fc)renderOffset, builder, 1.0, partialTicks);
        }
    }

    @ApiStatus.Internal
    void onRemoved() {
        this.cancelTasks();
        for (QuasarParticle particle : this.particles) {
            particle.onRemove();
        }
        this.particles.clear();
    }

    public int trim(int count) {
        int i;
        int removeCount = Math.min(count, this.particles.size());
        for (i = 0; i < removeCount; ++i) {
            this.particles.get(i).remove();
        }
        return i;
    }

    public void remove() {
        this.removed = true;
        this.cancelTasks();
    }

    public void reset() {
        this.removed = false;
        if (this.removeTask != null) {
            this.removeTask.cancel(false);
        }
        this.removeTask = this.particleManager.getScheduler().schedule(this::expire, this.emitterData.maxLifetime());
    }

    @Nullable
    public class_2960 getRegistryName() {
        return this.emitterData.getRegistryId();
    }

    public boolean isRemoved() {
        return this.removed && this.particles.isEmpty();
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public ParticleEmitterData getData() {
        return this.emitterData;
    }

    public int getParticleCount() {
        return this.particles.size();
    }

    @Nullable
    public class_1297 getAttachedEntity() {
        return this.attachedEntity;
    }

    @Deprecated
    public void setPosition(class_243 position) {
        this.position.set(position.field_1352, position.field_1351, position.field_1350);
    }

    public void setPosition(Vector3dc position) {
        this.position.set(position);
    }

    public void setAttachedEntity(@Nullable class_1297 entity) {
        this.attachedEntity = entity;
        if (entity != null) {
            this.position.set(entity.method_23317(), entity.method_23318(), entity.method_23321());
        }
    }
}

