/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.fx;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.joml.Vector3f;

public class Line {
    private class_243[] points;
    private int color;
    private Function<Float, Float> widthFunction;
    private int length = 100;
    private boolean billboard = true;
    private TilingMode tilingMode = TilingMode.STRETCH;
    private int frequency = 1;
    private float minDistance = 0.0f;
    private class_2960 texture = null;
    private CurveMode curveMode = CurveMode.NONE;

    public Line(class_243[] points, int color, Function<Float, Float> widthFunction) {
        this.points = points;
        this.color = color;
        this.widthFunction = widthFunction;
    }

    public Line(int color, Function<Float, Float> widthFunction) {
        this(new class_243[]{class_243.field_1353}, color, widthFunction);
    }

    public void setCurveMode(CurveMode curveMode) {
        this.curveMode = curveMode;
    }

    public void setTilingMode(TilingMode tilingMode) {
        this.tilingMode = tilingMode;
    }

    public void setTexture(class_2960 texture) {
        this.texture = texture;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public void setMinDistance(float minDistance) {
        this.minDistance = minDistance;
    }

    public void setPoints(class_243[] points) {
        if (points.length > this.length) {
            class_243[] newPoints = new class_243[this.length];
            System.arraycopy(points, points.length - this.length, newPoints, 0, this.length);
            points = newPoints;
        }
        this.points = points;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setWidthFunction(Function<Float, Float> widthFunction) {
        this.widthFunction = widthFunction;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setBillboard(boolean billboard) {
        this.billboard = billboard;
    }

    public class_243[] getPoints() {
        return this.points;
    }

    public int getColor() {
        return this.color;
    }

    public Function<Float, Float> getWidthFunction() {
        return this.widthFunction;
    }

    public int getLength() {
        return this.length;
    }

    public boolean getBillboard() {
        return this.billboard;
    }

    public TilingMode getTilingMode() {
        return this.tilingMode;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public float getMinDistance() {
        return this.minDistance;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public CurveMode getCurveMode() {
        return this.curveMode;
    }

    public void addPoint(class_243 point) {
        class_243[] newPoints = new class_243[this.points.length + 1];
        System.arraycopy(this.points, 0, newPoints, 0, this.points.length);
        newPoints[this.points.length] = point;
        this.points = newPoints;
    }

    public void removePoint(int index) {
        class_243[] newPoints = new class_243[this.points.length - 1];
        System.arraycopy(this.points, 0, newPoints, 0, index);
        System.arraycopy(this.points, index + 1, newPoints, index, this.points.length - index - 1);
        this.points = newPoints;
    }

    public class_243[] setupCurvePoints() {
        return this.curveMode.curveFunction.apply(this.points, this.frequency);
    }

    public void render(class_4587 stack, class_4588 consumer, int light) {
        stack.method_22903();
        RenderSystem.disableCull();
        class_243[] curvePoints = this.setupCurvePoints();
        Vector3f[][] corners = new Vector3f[curvePoints.length][2];
        for (int i = 0; i < curvePoints.length; ++i) {
            float width = this.widthFunction.apply(Float.valueOf((float)i / (float)(curvePoints.length - 1))).floatValue();
            Vector3f topOffset = new Vector3f(0.0f, width / 2.0f, 0.0f);
            Vector3f bottomOffset = new Vector3f(0.0f, -(width / 2.0f), 0.0f);
            if (this.billboard) {
                // empty if block
            }
            topOffset.add((float)curvePoints[i].field_1352, (float)curvePoints[i].field_1351, (float)curvePoints[i].field_1350);
            bottomOffset.add((float)curvePoints[i].field_1352, (float)curvePoints[i].field_1351, (float)curvePoints[i].field_1350);
            corners[i / this.frequency][0] = topOffset;
            corners[i / this.frequency][1] = bottomOffset;
        }
        this.renderPoints(stack, consumer, light, corners, this.color);
        RenderSystem.enableCull();
        stack.method_22909();
    }

    private void renderPoints(class_4587 stack, class_4588 consumer, int light, Vector3f[][] corners, int color) {
        stack.method_22903();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        for (int i = 0; i < corners.length - 1; ++i) {
            Vector3f top = corners[i][0];
            Vector3f bottom = corners[i][1];
            Vector3f nextTop = corners[i + 1][0];
            Vector3f nextBottom = corners[i + 1][1];
            if (nextTop == null) {
                nextTop = top;
            }
            if (nextBottom == null) {
                nextBottom = bottom;
            }
            if (top == null || bottom == null) continue;
            float u = 0.0f;
            float u1 = 1.0f;
            if (this.tilingMode == TilingMode.STRETCH) {
                u = (float)i / (float)(corners.length - 1);
                u1 = (float)(i + 1) / (float)(corners.length - 1);
            }
            consumer.method_22918(stack.method_23760().method_23761(), bottom.x(), bottom.y(), bottom.z()).method_22915(r, g, b, a).method_22913(u, 0.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            consumer.method_22918(stack.method_23760().method_23761(), top.x(), top.y(), top.z()).method_22915(r, g, b, a).method_22913(u, 1.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            consumer.method_22918(stack.method_23760().method_23761(), nextTop.x(), nextTop.y(), nextTop.z()).method_22915(r, g, b, a).method_22913(u1, 1.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            consumer.method_22918(stack.method_23760().method_23761(), nextBottom.x(), nextBottom.y(), nextBottom.z()).method_22915(r, g, b, a).method_22913(u1, 0.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        }
        stack.method_22909();
    }

    public static enum TilingMode {
        NONE,
        STRETCH,
        REPEAT;

    }

    public static enum CurveMode {
        NONE((points, freq) -> points),
        BEZIER((points, freq) -> {
            class_243[] curvePoints = new class_243[(((class_243[])points).length - 2) * freq];
            for (int i = 0; i < ((class_243[])points).length - 1; ++i) {
                class_243 p0 = points[i];
                class_243 p1 = points[i + 1];
                class_243 p2 = points[Math.min(i + 2, ((class_243[])points).length - 1)];
                class_243 p3 = points[Math.min(i + 3, ((class_243[])points).length - 1)];
                for (int j = 0; j < freq; ++j) {
                    float t = (float)j / (float)freq.intValue();
                    float t2 = t * t;
                    float t3 = t2 * t;
                    float x = (float)(0.5 * (2.0 * p1.method_10216() + (-p0.method_10216() + p2.method_10216()) * (double)t + (2.0 * p0.method_10216() - 5.0 * p1.method_10216() + 4.0 * p2.method_10216() - p3.method_10216()) * (double)t2 + (-p0.method_10216() + 3.0 * p1.method_10216() - 3.0 * p2.method_10216() + p3.method_10216()) * (double)t3));
                    float y = (float)(0.5 * (2.0 * p1.method_10214() + (-p0.method_10214() + p2.method_10214()) * (double)t + (2.0 * p0.method_10214() - 5.0 * p1.method_10214() + 4.0 * p2.method_10214() - p3.method_10214()) * (double)t2 + (-p0.method_10214() + 3.0 * p1.method_10214() - 3.0 * p2.method_10214() + p3.method_10214()) * (double)t3));
                    float z = (float)(0.5 * (2.0 * p1.method_10215() + (-p0.method_10215() + p2.method_10215()) * (double)t + (2.0 * p0.method_10215() - 5.0 * p1.method_10215() + 4.0 * p2.method_10215() - p3.method_10215()) * (double)t2 + (-p0.method_10215() + 3.0 * p1.method_10215() - 3.0 * p2.method_10215() + p3.method_10215()) * (double)t3));
                    curvePoints[i * freq.intValue() + j] = new class_243((double)x, (double)y, (double)z);
                }
            }
            return curvePoints;
        }),
        CATMULL_ROM((points, freq) -> {
            class_243[] curvePoints = new class_243[((class_243[])points).length * freq];
            for (int i = 0; i < ((class_243[])points).length - 1; ++i) {
                class_243 p0 = points[Math.max(i - 1, 0)];
                class_243 p1 = points[i];
                class_243 p2 = points[Math.min(i + 1, ((class_243[])points).length - 1)];
                class_243 p3 = points[Math.min(i + 2, ((class_243[])points).length - 1)];
                for (int j = 0; j < freq; ++j) {
                    float t = (float)j / (float)freq.intValue();
                    float t2 = t * t;
                    float t3 = t2 * t;
                    float x = (float)(0.5 * (2.0 * p1.method_10216() + (-p0.method_10216() + p2.method_10216()) * (double)t + (2.0 * p0.method_10216() - 5.0 * p1.method_10216() + 4.0 * p2.method_10216() - p3.method_10216()) * (double)t2 + (-p0.method_10216() + 3.0 * p1.method_10216() - 3.0 * p2.method_10216() + p3.method_10216()) * (double)t3));
                    float y = (float)(0.5 * (2.0 * p1.method_10214() + (-p0.method_10214() + p2.method_10214()) * (double)t + (2.0 * p0.method_10214() - 5.0 * p1.method_10214() + 4.0 * p2.method_10214() - p3.method_10214()) * (double)t2 + (-p0.method_10214() + 3.0 * p1.method_10214() - 3.0 * p2.method_10214() + p3.method_10214()) * (double)t3));
                    float z = (float)(0.5 * (2.0 * p1.method_10215() + (-p0.method_10215() + p2.method_10215()) * (double)t + (2.0 * p0.method_10215() - 5.0 * p1.method_10215() + 4.0 * p2.method_10215() - p3.method_10215()) * (double)t2 + (-p0.method_10215() + 3.0 * p1.method_10215() - 3.0 * p2.method_10215() + p3.method_10215()) * (double)t3));
                    curvePoints[i * freq.intValue() + j] = new class_243((double)x, (double)y, (double)z);
                }
            }
            return curvePoints;
        });

        final BiFunction<class_243[], Integer, class_243[]> curveFunction;

        private CurveMode(BiFunction<class_243[], Integer, class_243[]> curveFunction) {
            this.curveFunction = curveFunction;
        }
    }

    public static enum RenderMode {
        FLAT,
        CUBOID;

    }
}

