/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import foundry.veil.api.quasar.data.module.ModuleType;

public class ParticleModuleTypeRegistry {
    private static final BiMap<String, ModuleType<?>> INIT_MODULES = HashBiMap.create();
    private static final BiMap<String, ModuleType<?>> UPDATE_MODULES = HashBiMap.create();
    private static final BiMap<String, ModuleType<?>> RENDER_MODULES = HashBiMap.create();
    public static final Codec<ModuleType<?>> INIT_MODULE_CODEC;
    public static final Codec<ModuleType<?>> UPDATE_MODULE_CODEC;
    public static final Codec<ModuleType<?>> RENDER_MODULE_CODEC;

    public static void registerInit(String name, ModuleType<?> type) {
        INIT_MODULES.put((Object)name, type);
    }

    public static void registerUpdate(String name, ModuleType<?> type) {
        UPDATE_MODULES.put((Object)name, type);
    }

    public static void registerRender(String name, ModuleType<?> type) {
        RENDER_MODULES.put((Object)name, type);
    }

    public static String getName(ModuleType<?> type) {
        String initModuleName = (String)INIT_MODULES.inverse().get(type);
        if (initModuleName != null) {
            return initModuleName;
        }
        String updateModuleName = (String)UPDATE_MODULES.inverse().get(type);
        if (updateModuleName != null) {
            return updateModuleName;
        }
        String renderModuleName = (String)RENDER_MODULES.inverse().get(type);
        if (renderModuleName != null) {
            return renderModuleName;
        }
        return type.getClass().getName();
    }

    static {
        ModuleType.bootstrap();
        INIT_MODULE_CODEC = Codec.STRING.comapFlatMap(name -> {
            ModuleType module = (ModuleType)INIT_MODULES.get(name);
            if (module == null) {
                return DataResult.error(() -> "Invalid Init Module: %s".formatted(name));
            }
            return DataResult.success((Object)module);
        }, arg_0 -> INIT_MODULES.inverse().get(arg_0));
        UPDATE_MODULE_CODEC = Codec.STRING.comapFlatMap(name -> {
            ModuleType module = (ModuleType)UPDATE_MODULES.get(name);
            if (module == null) {
                return DataResult.error(() -> "Invalid Update Module: %s".formatted(name));
            }
            return DataResult.success((Object)module);
        }, arg_0 -> UPDATE_MODULES.inverse().get(arg_0));
        RENDER_MODULE_CODEC = Codec.STRING.comapFlatMap(name -> {
            ModuleType module = (ModuleType)RENDER_MODULES.get(name);
            if (module == null) {
                return DataResult.error(() -> "Invalid Render Module: %s".formatted(name));
            }
            return DataResult.success((Object)module);
        }, arg_0 -> RENDER_MODULES.inverse().get(arg_0));
    }
}

