/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.quasar.emitters.shape.Cube;
import foundry.veil.api.quasar.emitters.shape.Cylinder;
import foundry.veil.api.quasar.emitters.shape.Disc;
import foundry.veil.api.quasar.emitters.shape.EmitterShape;
import foundry.veil.api.quasar.emitters.shape.Hemisphere;
import foundry.veil.api.quasar.emitters.shape.Plane;
import foundry.veil.api.quasar.emitters.shape.Point;
import foundry.veil.api.quasar.emitters.shape.Sphere;
import foundry.veil.api.quasar.emitters.shape.Torus;
import foundry.veil.impl.quasar.CodecUtil;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_5381;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public record EmitterShapeSettings(EmitterShape shape, Vector3fc dimensions, Vector3fc rotation, boolean fromSurface) {
    public static final BiMap<String, EmitterShape> SHAPES = HashBiMap.create(Map.of("point", new Point(), "hemisphere", new Hemisphere(), "cylinder", new Cylinder(), "sphere", new Sphere(), "cube", new Cube(), "torus", new Torus(), "disc", new Disc(), "plane", new Plane()));
    public static final Codec<EmitterShapeSettings> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("shape").xmap(s -> (EmitterShape)SHAPES.getOrDefault((Object)s.toLowerCase(), (Object)new Point()), s -> (String)SHAPES.inverse().get(s)).forGetter(EmitterShapeSettings::shape), (App)CodecUtil.VECTOR3F_CODEC.fieldOf("dimensions").forGetter(EmitterShapeSettings::dimensions), (App)CodecUtil.VECTOR3F_CODEC.fieldOf("rotation").forGetter(EmitterShapeSettings::rotation), (App)Codec.BOOL.fieldOf("from_surface").forGetter(EmitterShapeSettings::fromSurface)).apply((Applicative)instance, EmitterShapeSettings::new));
    public static final Codec<class_6880<EmitterShapeSettings>> CODEC = class_5381.method_29749(QuasarParticles.EMITTER_SHAPE_SETTINGS, DIRECT_CODEC);

    public Vector3d getPos(class_5819 randomSource, Vector3dc pos) {
        return this.shape.getPoint(randomSource, this.dimensions, this.rotation, pos, this.fromSurface);
    }

    @Nullable
    public class_2960 getRegistryId() {
        return QuasarParticles.registryAccess().method_30530(QuasarParticles.EMITTER_SHAPE_SETTINGS).method_10221((Object)this);
    }
}

