/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light;

import foundry.veil.api.client.render.deferred.light.IndirectLight;
import foundry.veil.api.client.render.deferred.light.Light;
import java.nio.ByteBuffer;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class PointLight
extends Light
implements IndirectLight<PointLight> {
    protected final Vector3d position = new Vector3d();
    protected float radius = 1.0f;

    @Override
    public void store(ByteBuffer buffer) {
        this.position.getf(buffer.position(), buffer);
        buffer.position(buffer.position() + 12);
        buffer.putFloat(this.color.x() * this.brightness);
        buffer.putFloat(this.color.y() * this.brightness);
        buffer.putFloat(this.color.z() * this.brightness);
        buffer.putFloat(this.radius);
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public PointLight setColor(float red, float green, float blue) {
        return (PointLight)super.setColor(red, green, blue);
    }

    @Override
    public PointLight setColor(Vector3fc color) {
        return (PointLight)super.setColor(color);
    }

    @Override
    public PointLight setBrightness(float brightness) {
        return (PointLight)super.setBrightness(brightness);
    }

    @Override
    public PointLight setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
        this.markDirty();
        return this;
    }

    @Override
    public PointLight setRadius(float radius) {
        this.radius = radius;
        this.markDirty();
        return this;
    }

    @Override
    public Light.Type getType() {
        return Light.Type.POINT;
    }

    @Override
    public PointLight clone() {
        return ((PointLight)new PointLight().setPosition((Vector3dc)this.position)).setColor((Vector3fc)this.color).setRadius(this.radius).setBrightness(this.brightness);
    }
}

