/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.LightTypeRenderer;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.deferred.light.VanillaLightRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public class LightRenderer
implements NativeResource {
    private final Map<Light.Type, LightData<?>> lights = new EnumMap(Light.Type.class);
    private VanillaLightRenderer vanillaLightRenderer;
    private boolean vanillaLightEnabled = true;
    private boolean ambientOcclusionEnabled = true;
    private AdvancedFbo framebuffer;

    public void applyShader() {
        ShaderProgram shader = VeilRenderSystem.getShader();
        if (shader == null) {
            VeilRenderSystem.throwShaderError();
            return;
        }
        shader.bind();
        if (this.framebuffer != null) {
            shader.setFramebufferSamplers(this.framebuffer);
            shader.setVector("ScreenSize", this.framebuffer.getWidth(), this.framebuffer.getHeight());
        } else {
            shader.setVector("ScreenSize", 1.0f, 1.0f);
        }
        shader.applyShaderSamplers(0);
    }

    public void render(CullFrustum frustum, AdvancedFbo framebuffer) {
        class_638 level;
        this.framebuffer = framebuffer;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        RenderSystem.depthMask((boolean)false);
        for (LightData<?> value : this.lights.values()) {
            value.render(this, frustum);
        }
        if (this.vanillaLightEnabled && (level = class_310.method_1551().field_1687) != null) {
            if (this.vanillaLightRenderer == null) {
                this.vanillaLightRenderer = new VanillaLightRenderer();
            }
            this.vanillaLightRenderer.render(this, level);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        this.framebuffer = null;
    }

    public void addLight(Light light) {
        Objects.requireNonNull(light, "light");
        RenderSystem.assertOnRenderThreadOrInit();
        this.lights.computeIfAbsent(light.getType(), LightData::new).addLight(light);
    }

    public void removeLight(Light light) {
        Objects.requireNonNull(light, "light");
        RenderSystem.assertOnRenderThreadOrInit();
        LightData<?> data = this.lights.get((Object)light.getType());
        if (data != null) {
            data.lights.remove(light);
        }
    }

    public <T extends Light> List<T> getLights(Light.Type type) {
        LightData<?> data = this.lights.get((Object)type);
        if (data == null) {
            return Collections.emptyList();
        }
        return data.lightsView;
    }

    public void enableVanillaLight() {
        this.vanillaLightEnabled = true;
    }

    public void disableVanillaLight() {
        this.vanillaLightEnabled = false;
        if (this.vanillaLightRenderer != null) {
            this.vanillaLightRenderer.free();
            this.vanillaLightRenderer = null;
        }
    }

    public void enableAmbientOcclusion() {
        if (!this.ambientOcclusionEnabled) {
            this.ambientOcclusionEnabled = true;
            class_310.method_1551().field_1769.method_3279();
        }
    }

    public void disableAmbientOcclusion() {
        if (this.ambientOcclusionEnabled) {
            this.ambientOcclusionEnabled = false;
            class_310.method_1551().field_1769.method_3279();
        }
    }

    @Nullable
    public AdvancedFbo getFramebuffer() {
        return this.framebuffer;
    }

    public boolean isVanillaLightEnabled() {
        return this.vanillaLightEnabled;
    }

    public boolean isAmbientOcclusionEnabled() {
        return this.ambientOcclusionEnabled;
    }

    public void free() {
        this.lights.values().forEach(LightData::free);
        this.lights.clear();
        if (this.vanillaLightRenderer != null) {
            this.vanillaLightRenderer.free();
            this.vanillaLightRenderer = null;
        }
    }

    @ApiStatus.Internal
    public void addDebugInfo(Consumer<String> consumer) {
        int visible = this.lights.values().stream().mapToInt(data -> data.renderer.getVisibleLights()).sum();
        int all = this.lights.values().stream().mapToInt(data -> data.lights.size()).sum();
        consumer.accept("Lights: " + visible + " / " + all);
    }

    @ApiStatus.Internal
    private static class LightData<T extends Light>
    implements NativeResource {
        private final LightTypeRenderer<T> renderer;
        private final List<T> lights;
        private final List<T> lightsView;
        private final Set<T> removedLights;

        private LightData(LightTypeRenderer<T> renderer) {
            this.renderer = renderer;
            this.lights = new ArrayList<T>();
            this.lightsView = Collections.unmodifiableList(this.lights);
            this.removedLights = new HashSet<T>();
        }

        public LightData(Light.Type type) {
            this(Objects.requireNonNull(type, "type").createRenderer());
        }

        private void render(LightRenderer lightRenderer, CullFrustum frustum) {
            this.lights.removeAll(this.removedLights);
            this.renderer.renderLights(lightRenderer, this.lights, this.removedLights, frustum);
            this.removedLights.clear();
        }

        private void addLight(Light light) {
            this.lights.add(light);
        }

        public void free() {
            this.renderer.free();
        }
    }
}

