/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light;

import foundry.veil.Veil;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.deferred.light.IndirectLight;
import foundry.veil.api.client.render.deferred.light.InstancedLight;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.LightRenderer;
import foundry.veil.api.client.render.deferred.light.LightTypeRenderer;
import foundry.veil.api.client.render.deferred.light.PositionedLight;
import foundry.veil.api.opencl.CLBuffer;
import foundry.veil.api.opencl.CLEnvironment;
import foundry.veil.api.opencl.CLEnvironmentOptions;
import foundry.veil.api.opencl.CLException;
import foundry.veil.api.opencl.CLKernel;
import foundry.veil.api.opencl.VeilOpenCL;
import foundry.veil.ext.VertexBufferExtension;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Set;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_2960;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public abstract class IndirectLightRenderer<T extends Light>
implements LightTypeRenderer<T> {
    private static final CLEnvironment ENVIRONMENT = VeilOpenCL.get().getEnvironment(CLEnvironmentOptions.builder().setRequireGL(true).build());
    private static final int MIN_LIGHTS = 20;
    protected final int lightSize;
    protected final int highResSize;
    protected final int lowResSize;
    protected int maxLights;
    private final class_291 vbo;
    private final int instancedVbo;
    private final int indirectVbo;
    private int visibleLights;
    private CLKernel kernel;
    private CLBuffer clCounter;
    private CLBuffer clFrustumPlanes;
    private CLBuffer clInstancedBuffer;
    private CLBuffer clIndirectBuffer;

    public IndirectLightRenderer(int lightSize, int lowResSize, int positionOffset, int rangeOffset) {
        this.lightSize = lightSize;
        this.maxLights = 20;
        this.vbo = new class_291(class_291.class_8555.field_44793);
        this.instancedVbo = GL15C.glGenBuffers();
        this.indirectVbo = GL15C.glGenBuffers();
        this.vbo.method_1353();
        this.vbo.method_1352(this.createMesh());
        VertexBufferExtension ext = (VertexBufferExtension)this.vbo;
        this.highResSize = ext.veil$getIndexCount() - lowResSize;
        this.lowResSize = lowResSize;
        if (ENVIRONMENT != null) {
            class_2960 name = Veil.veilPath("indirect_light");
            ENVIRONMENT.loadProgram(name, "bool testSphere(global const float* FrustumPlanes, const float x, const float y, const float z, const float r) {\n    return FrustumPlanes[0] * x + FrustumPlanes[1] * y + FrustumPlanes[2] * z + FrustumPlanes[3] >= -r &&\n           FrustumPlanes[4] * x + FrustumPlanes[5] * y + FrustumPlanes[6] * z + FrustumPlanes[7] >= -r &&\n           FrustumPlanes[8] * x + FrustumPlanes[9] * y + FrustumPlanes[10] * z + FrustumPlanes[11] >= -r &&\n           FrustumPlanes[12] * x + FrustumPlanes[13] * y + FrustumPlanes[14] * z + FrustumPlanes[15] >= -r &&\n           FrustumPlanes[16] * x + FrustumPlanes[17] * y + FrustumPlanes[18] * z + FrustumPlanes[19] >= -r &&\n           FrustumPlanes[20] * x + FrustumPlanes[21] * y + FrustumPlanes[22] * z + FrustumPlanes[23] >= -r;\n}\n\nvoid kernel update_draw(const float4 CameraPos, volatile global int* Counter, global const float* FrustumPlanes, global const float* LightData, global uint* DrawData) {\n    const int lightId = get_global_id(0);\n    const int lightDataIndex = lightId * %d;\n    float x = LightData[lightDataIndex + %d];\n    float y = LightData[lightDataIndex + %d];\n    float z = LightData[lightDataIndex + %d];\n    float range = LightData[lightDataIndex + %d];\n\n    bool visible = testSphere(FrustumPlanes, x - CameraPos.x, y - CameraPos.y, z - CameraPos.z, range * 1.414);\n    if (visible) {\n        int i = atomic_inc(Counter) * 5;\n        DrawData[i] = %d;\n        DrawData[i + 1] = 1;\n        DrawData[i + 2] = %d;\n        DrawData[i + 3] = 0;\n        DrawData[i + 4] = lightId;\n    }\n}\n".formatted(lightSize, positionOffset, positionOffset + 1, positionOffset + 2, rangeOffset, this.highResSize, 0));
            try {
                this.kernel = ENVIRONMENT.createKernel(name, "update_draw");
                this.clCounter = this.kernel.createBuffer(1, 4L);
                this.clFrustumPlanes = this.kernel.createBuffer(4, 96L);
                this.kernel.setPointers(1, this.clCounter);
                this.kernel.setPointers(2, this.clFrustumPlanes);
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to create indirect kernel", (Throwable)e);
                this.freeCL();
            }
        }
        GL15C.glBindBuffer((int)34962, (int)this.instancedVbo);
        GL15C.glBindBuffer((int)36671, (int)this.indirectVbo);
        this.initBuffers();
        GL15C.glBindBuffer((int)36671, (int)0);
        this.setupBufferState();
        GL15C.glBindBuffer((int)34962, (int)0);
        class_291.method_1354();
    }

    protected abstract class_287.class_7433 createMesh();

    protected abstract void setupBufferState();

    protected abstract void setupRenderState(LightRenderer var1, List<T> var2);

    protected abstract void clearRenderState(LightRenderer var1, List<T> var2);

    private void initBuffers() {
        GL15C.glBufferData((int)34962, (long)((long)this.maxLights * (long)this.lightSize), (int)35048);
        GL15C.glBufferData((int)36671, (long)((long)this.maxLights * 4L * 5L), (int)35048);
        if (this.kernel != null) {
            try {
                if (this.clInstancedBuffer != null) {
                    this.clInstancedBuffer.free();
                }
                if (this.clIndirectBuffer != null) {
                    this.clIndirectBuffer.free();
                }
                this.clInstancedBuffer = this.kernel.createBufferFromGL(4, this.instancedVbo);
                this.clIndirectBuffer = this.kernel.createBufferFromGL(2, this.indirectVbo);
                this.kernel.setPointers(3, this.clInstancedBuffer);
                this.kernel.setPointers(4, this.clIndirectBuffer);
            }
            catch (CLException e) {
                Veil.LOGGER.error("Failed to initialize indirect compute", (Throwable)e);
                this.freeCL();
            }
        } else {
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer buffer = stack.calloc(20);
                buffer.putInt(0, ((VertexBufferExtension)this.vbo).veil$getIndexCount());
                buffer.putInt(4, 1);
                for (int i = 0; i < this.maxLights; ++i) {
                    GL15C.glBufferSubData((int)36671, (long)((long)(i * 4) * 5L), (ByteBuffer)buffer);
                }
            }
        }
    }

    private boolean shouldDrawHighResolution(T light, CullFrustum frustum) {
        float radius = ((IndirectLight)light).getRadius();
        return frustum.getPosition().distanceSquared((Vector3dc)((PositionedLight)light).getPosition()) <= (double)(radius * radius);
    }

    private boolean isVisible(T light, CullFrustum frustum) {
        Vector3d position = ((PositionedLight)light).getPosition();
        float radius = ((IndirectLight)light).getRadius();
        return frustum.testSphere(position.x, position.y, position.z, radius * 1.414f);
    }

    private void updateAllLights(List<T> lights) {
        ByteBuffer dataBuffer = MemoryUtil.memAlloc((int)(lights.size() * this.lightSize));
        int pointer = 0;
        for (Light light : lights) {
            light.clean();
            dataBuffer.position(pointer++ * this.lightSize);
            ((InstancedLight)((Object)light)).store(dataBuffer);
        }
        if (pointer > 0) {
            dataBuffer.rewind();
            GL15C.glBufferSubData((int)34962, (long)0L, (ByteBuffer)dataBuffer);
        }
        MemoryUtil.memFree((Buffer)dataBuffer);
    }

    private int updateVisibility(List<T> lights, CullFrustum frustum) {
        if (this.kernel != null) {
            int n;
            block20: {
                MemoryStack stack = MemoryStack.stackPush();
                try {
                    this.kernel.acquireFromGL(this.clInstancedBuffer, this.clIndirectBuffer);
                    this.clCounter.writeAsync(0L, stack.ints(0), null);
                    ByteBuffer planes = stack.malloc(96);
                    int index = 0;
                    for (Vector4fc plane : frustum.getPlanes()) {
                        plane.get(index, planes);
                        index += 16;
                    }
                    this.clFrustumPlanes.writeAsync(0L, planes, null);
                    Vector3dc pos = frustum.getPosition();
                    this.kernel.setVector4f(0, (float)pos.x(), (float)pos.y(), (float)pos.z(), 0.0f);
                    this.kernel.execute(lights.size(), 1);
                    this.kernel.releaseToGL(this.clInstancedBuffer, this.clIndirectBuffer);
                    IntBuffer data = stack.mallocInt(1);
                    this.clCounter.read(0L, data);
                    n = data.get(0);
                    if (stack == null) break block20;
                }
                catch (Throwable planes) {
                    try {
                        if (stack != null) {
                            try {
                                stack.close();
                            }
                            catch (Throwable index) {
                                planes.addSuppressed(index);
                            }
                        }
                        throw planes;
                    }
                    catch (CLException e) {
                        Veil.LOGGER.error("Failed to run indirect compute", (Throwable)e);
                        this.freeCL();
                    }
                }
                stack.close();
            }
            return n;
        }
        int count = 0;
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer buffer = stack.malloc(this.lowResSize > 0 ? 20 : 4);
            int index = 0;
            for (Light light : lights) {
                if (this.isVisible(light, frustum)) {
                    if (this.lowResSize > 0) {
                        boolean highRes = this.shouldDrawHighResolution(light, frustum);
                        buffer.putInt(0, highRes ? this.highResSize : this.lowResSize);
                        buffer.putInt(4, 1);
                        buffer.putInt(8, !highRes ? this.highResSize : 0);
                        buffer.putInt(12, 0);
                        buffer.putInt(16, index);
                        GL15C.glBufferSubData((int)36671, (long)((long)(count * 4) * 5L), (ByteBuffer)buffer);
                    } else {
                        buffer.putInt(0, index);
                        GL15C.glBufferSubData((int)36671, (long)((long)(count * 4) * 5L + 16L), (ByteBuffer)buffer);
                    }
                    ++count;
                }
                ++index;
            }
        }
        return count;
    }

    @Override
    public void renderLights(LightRenderer lightRenderer, List<T> lights, Set<T> removedLights, CullFrustum frustum) {
        VertexBufferExtension ext = (VertexBufferExtension)this.vbo;
        this.vbo.method_1353();
        GL15C.glBindBuffer((int)34962, (int)this.instancedVbo);
        GL15C.glBindBuffer((int)36671, (int)this.indirectVbo);
        boolean rebuild = false;
        if (lights.size() > this.maxLights || this.maxLights > 20 && this.maxLights > lights.size() * 2) {
            rebuild = true;
            this.maxLights = (int)Math.max(Math.max(Math.ceil((double)this.maxLights / 2.0), 20.0), (double)lights.size() * 1.5);
            this.initBuffers();
        }
        if (rebuild || !removedLights.isEmpty()) {
            this.updateAllLights(lights);
        } else {
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer buffer = stack.malloc(this.lightSize);
                for (int i = 0; i < lights.size(); ++i) {
                    Light light = (Light)lights.get(i);
                    if (!light.isDirty()) continue;
                    light.clean();
                    ((InstancedLight)((Object)light)).store(buffer);
                    buffer.rewind();
                    GL15C.glBufferSubData((int)34962, (long)((long)i * (long)this.lightSize), (ByteBuffer)buffer);
                }
            }
        }
        int n = this.visibleLights = !lights.isEmpty() ? this.updateVisibility(lights, frustum) : 0;
        if (this.visibleLights > 0) {
            this.setupRenderState(lightRenderer, lights);
            lightRenderer.applyShader();
            ext.veil$drawIndirect(0L, this.visibleLights, 0);
            this.clearRenderState(lightRenderer, lights);
        }
        GL15C.glBindBuffer((int)34962, (int)0);
        GL15C.glBindBuffer((int)36671, (int)0);
        class_291.method_1354();
    }

    private void freeCL() {
        if (this.kernel != null) {
            this.kernel.free();
            this.kernel = null;
        }
        this.clCounter = null;
        this.clFrustumPlanes = null;
        this.clInstancedBuffer = null;
        this.clIndirectBuffer = null;
    }

    @Override
    public int getVisibleLights() {
        return this.visibleLights;
    }

    public void free() {
        this.vbo.close();
        GL15C.glDeleteBuffers((int)this.instancedVbo);
        GL15C.glDeleteBuffers((int)this.indirectVbo);
        this.freeCL();
    }
}

