/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light;

import foundry.veil.api.client.render.deferred.light.InstancedLight;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.PositionedLight;
import java.nio.ByteBuffer;
import net.minecraft.class_3532;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class AreaLight
extends Light
implements InstancedLight,
PositionedLight<AreaLight> {
    private static final float MAX_ANGLE_SIZE = 10430.06f;
    protected final Vector3d position;
    protected final Quaternionf orientation;
    private final Matrix4d matrix = new Matrix4d();
    protected final Vector2f size;
    protected float angle;
    protected float distance = 1.0f;

    public AreaLight() {
        this.position = new Vector3d();
        this.orientation = new Quaternionf();
        this.size = new Vector2f(1.0f, 1.0f);
        this.angle = (float)Math.toRadians(45.0);
    }

    @Override
    public void store(ByteBuffer buffer) {
        this.matrix.getFloats(buffer.position(), buffer);
        buffer.position(buffer.position() + 64);
        buffer.putFloat(this.color.x() * this.brightness);
        buffer.putFloat(this.color.y() * this.brightness);
        buffer.putFloat(this.color.z() * this.brightness);
        this.size.get(buffer.position(), buffer);
        buffer.position(buffer.position() + 8);
        buffer.putShort((short)class_3532.method_15340((int)((int)(this.angle * 10430.06f)), (int)0, (int)65535));
        buffer.putFloat(this.distance);
    }

    @Override
    public Light.Type getType() {
        return Light.Type.AREA;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    public Quaternionf getOrientation() {
        return this.orientation;
    }

    public Vector2f getSize() {
        return this.size;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getDistance() {
        return this.distance;
    }

    @Override
    public AreaLight setColor(float red, float green, float blue) {
        return (AreaLight)super.setColor(red, green, blue);
    }

    @Override
    public AreaLight setColor(Vector3fc color) {
        return (AreaLight)super.setColor(color);
    }

    @Override
    public AreaLight setBrightness(float brightness) {
        return (AreaLight)super.setBrightness(brightness);
    }

    @Override
    public AreaLight setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
        this.updateMatrix();
        return this;
    }

    public AreaLight setOrientation(Quaternionfc orientation) {
        this.orientation.set(orientation).normalize();
        this.updateMatrix();
        return this;
    }

    public AreaLight setSize(double x, double y) {
        this.size.set(x, y);
        this.markDirty();
        return this;
    }

    public AreaLight setAngle(float angle) {
        this.angle = angle;
        this.markDirty();
        return this;
    }

    public AreaLight setDistance(float distance) {
        this.distance = distance;
        this.markDirty();
        return this;
    }

    protected void updateMatrix() {
        Vector3d position = this.getPosition();
        Quaternionf orientation = this.getOrientation();
        this.matrix.rotation((Quaternionfc)orientation).translate((Vector3dc)position);
        this.markDirty();
    }

    @Override
    public AreaLight clone() {
        AreaLight light = new AreaLight();
        light.matrix.set((Matrix4dc)this.matrix);
        light.size.set((Vector2fc)this.size);
        light.angle = this.angle;
        light.distance = this.distance;
        light.markDirty();
        return light;
    }
}

