/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.imgui;

import imgui.ImGui;
import imgui.ImVec2;
import imgui.extension.texteditor.TextEditor;
import imgui.type.ImBoolean;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public class CodeEditor
implements NativeResource {
    private final TextEditor editor = new TextEditor();
    private final String saveText;
    private String oldSource;
    private SaveCallback saveCallback;
    private final ImBoolean open;

    public CodeEditor(@Nullable String saveText) {
        this.editor.setShowWhitespaces(false);
        this.saveText = saveText;
        this.oldSource = null;
        this.saveCallback = null;
        this.open = new ImBoolean();
    }

    public boolean hasTextChanged() {
        return this.oldSource != null && !this.oldSource.equals(this.editor.getText());
    }

    public void save() {
        HashMap<Integer, String> errors = new HashMap<Integer, String>();
        if (this.saveCallback != null) {
            this.saveCallback.save(this.editor.getText(), errors::put);
        }
        if (errors.isEmpty()) {
            this.oldSource = this.editor.getText();
        }
        this.editor.setErrorMarkers(errors);
    }

    public void show(String source) {
        this.editor.setText(source);
        this.oldSource = this.editor.getText();
        this.editor.setErrorMarkers(Collections.emptyMap());
        this.open.set(true);
        ImGui.setWindowFocus("###editor");
        ImGui.setWindowCollapsed("###editor", false);
    }

    public void hide() {
        if (this.hasTextChanged()) {
            this.open.set(true);
            ImGui.pushID(this.hashCode());
            ImGui.openPopup("###save_confirm");
            ImGui.popID();
        } else {
            this.oldSource = null;
            this.open.set(false);
        }
    }

    public void renderWindow() {
        int flags = 1024;
        if (this.hasTextChanged()) {
            flags |= 0x100000;
        }
        if (!this.open.get()) {
            return;
        }
        ImGui.pushID(this.hashCode());
        ImGui.setNextWindowSizeConstraints(800.0f, 600.0f, Float.MAX_VALUE, Float.MAX_VALUE);
        ImGui.begin("Editor###editor", this.open, flags);
        if (!this.open.get()) {
            this.hide();
        }
        this.render();
        ImGui.end();
        ImGui.popID();
    }

    public void render() {
        ImGui.pushID(this.hashCode());
        if (this.open.get()) {
            if (!this.hasTextChanged()) {
                this.editor.setErrorMarkers(Collections.emptyMap());
            }
            if (ImGui.beginMenuBar()) {
                boolean immutable = this.editor.isReadOnly();
                if (ImGui.menuItem("Read-only mode", "", immutable)) {
                    this.editor.setReadOnly(!immutable);
                }
                if (ImGui.menuItem("Show Whitespace", "", this.editor.isShowingWhitespaces())) {
                    this.editor.setShowWhitespaces(!this.editor.isShowingWhitespaces());
                }
                if (this.saveText != null && ImGui.menuItem(this.saveText)) {
                    this.save();
                }
                ImGui.separator();
                ImGui.beginDisabled(immutable);
                ImGui.beginDisabled(!this.editor.canUndo());
                if (ImGui.menuItem("Undo", "ALT-Backspace")) {
                    this.editor.undo(1);
                }
                ImGui.endDisabled();
                ImGui.beginDisabled(!this.editor.canRedo());
                if (ImGui.menuItem("Redo", "Ctrl-Y")) {
                    this.editor.redo(1);
                }
                ImGui.endDisabled();
                ImGui.endDisabled();
                ImGui.separator();
                ImGui.beginDisabled(!this.editor.hasSelection());
                if (ImGui.menuItem("Copy", "Ctrl-C")) {
                    this.editor.copy();
                }
                ImGui.endDisabled();
                ImGui.beginDisabled(immutable);
                ImGui.beginDisabled(!this.editor.hasSelection());
                if (ImGui.menuItem("Cut", "Ctrl-X")) {
                    this.editor.cut();
                }
                if (ImGui.menuItem("Delete", "Del")) {
                    this.editor.delete();
                }
                ImGui.endDisabled();
                ImGui.beginDisabled(ImGui.getClipboardText() == null);
                if (ImGui.menuItem("Paste", "Ctrl-V")) {
                    this.editor.paste();
                }
                ImGui.endDisabled();
                ImGui.endDisabled();
                ImGui.endMenuBar();
            }
            int cposX = this.editor.getCursorPositionLine();
            int cposY = this.editor.getCursorPositionColumn();
            String overwrite = this.editor.isOverwrite() ? "Ovr" : "Ins";
            String canUndo = this.editor.canUndo() ? "*" : " ";
            ImGui.text(cposX + ":" + cposY + " " + this.editor.getTotalLines() + " lines | " + overwrite + " | " + canUndo);
            this.editor.render("TextEditor");
        }
        ImVec2 center = ImGui.getMainViewport().getCenter();
        ImGui.setNextWindowPos(center.x, center.y, 8, 0.5f, 0.5f);
        if (ImGui.beginPopupModal(this.saveText + "?###save_confirm", 64)) {
            ImGui.text("Your changes have not been saved.\nThis operation cannot be undone!");
            ImGui.separator();
            ImGui.setItemDefaultFocus();
            if (ImGui.button(this.saveText)) {
                this.save();
                this.hide();
                ImGui.closeCurrentPopup();
            }
            ImGui.sameLine();
            if (ImGui.button("Discard")) {
                this.oldSource = null;
                this.hide();
                ImGui.closeCurrentPopup();
            }
            ImGui.sameLine();
            if (ImGui.button("Cancel")) {
                ImGui.closeCurrentPopup();
            }
            ImGui.endPopup();
        }
        ImGui.popID();
    }

    public TextEditor getEditor() {
        return this.editor;
    }

    public void setSaveCallback(@Nullable SaveCallback saveCallback) {
        this.saveCallback = saveCallback;
    }

    public void free() {
        this.editor.destroy();
    }

    @FunctionalInterface
    public static interface SaveCallback {
        public void save(String var1, BiConsumer<Integer, String> var2);
    }
}

