/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil;

import foundry.veil.api.molang.VeilMolang;
import foundry.veil.platform.services.VeilPlatform;
import gg.moonflower.molangcompiler.api.MolangCompiler;
import imgui.ImGui;
import java.util.ServiceLoader;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Veil {
    public static final String MODID = "veil";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Veil");
    public static final boolean DEBUG;
    public static final boolean IMGUI;
    private static final VeilPlatform PLATFORM;

    private static boolean hasImguiNatives() {
        String arch = System.getProperty("os.arch");
        boolean is64Bit = arch.contains("64") || arch.startsWith("armv8");
        boolean isARM = arch.equals("arm") || arch.startsWith("aarch64");
        Object libName = "imgui-java";
        if (isARM) {
            libName = (String)libName + "arm";
        }
        if (is64Bit) {
            libName = (String)libName + "64";
        }
        String name = System.mapLibraryName((String)libName);
        return ImGui.class.getClassLoader().getResource("io/imgui/java/native-bin/" + name) != null;
    }

    @ApiStatus.Internal
    public static void init() {
        LOGGER.info("Veil is initializing.");
        if (DEBUG) {
            LOGGER.info("Veil Debug Enabled");
        }
        if (!IMGUI) {
            LOGGER.info("ImGui Disabled");
        }
        VeilMolang.set(MolangCompiler.create(1, Veil.class.getClassLoader()));
    }

    public static class_2960 veilPath(String path) {
        return new class_2960(MODID, path);
    }

    public static VeilPlatform platform() {
        return PLATFORM;
    }

    static {
        PLATFORM = ServiceLoader.load(VeilPlatform.class).findFirst().orElseThrow(() -> new RuntimeException("Veil expected platform implementation"));
        DEBUG = System.getProperty("veil.debug") != null;
        IMGUI = System.getProperty("veil.disableImgui") == null && Veil.hasImguiNatives();
    }
}

