/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.wrapper;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboAttachment;
import foundry.veil.api.client.render.framebuffer.AdvancedFboTextureAttachment;
import foundry.veil.mixin.client.pipeline.RenderTargetAccessor;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL30C;

@ApiStatus.Internal
public class VanillaAdvancedFboWrapper
implements AdvancedFbo {
    private final Supplier<class_276> renderTargetSupplier;
    private final Supplier<AttachmentWrapper> colorBuffer;
    private final Supplier<AttachmentWrapper> depthBuffer;

    public VanillaAdvancedFboWrapper(Supplier<class_276> renderTargetSupplier) {
        this.renderTargetSupplier = renderTargetSupplier;
        this.colorBuffer = Suppliers.memoize(() -> new AttachmentWrapper(this, () -> this.toRenderTarget().method_30277(), 36064));
        this.depthBuffer = Suppliers.memoize(() -> new AttachmentWrapper(this, () -> this.toRenderTarget().method_30278(), 36096));
    }

    @Override
    public void create() {
        throw new UnsupportedOperationException("Vanilla framebuffers cannot be created");
    }

    @Override
    public void clear() {
        RenderSystem.assertOnRenderThreadOrInit();
        class_276 renderTarget = this.toRenderTarget();
        float[] clearChannels = ((RenderTargetAccessor)renderTarget).getClearChannels();
        RenderSystem.clearColor((float)clearChannels[0], (float)clearChannels[1], (float)clearChannels[2], (float)clearChannels[3]);
        int mask = 16384;
        if (renderTarget.field_1478) {
            RenderSystem.clearDepth((double)1.0);
            mask |= 0x100;
        }
        RenderSystem.clear((int)mask, (boolean)class_310.field_1703);
    }

    @Override
    public void bind(boolean setViewport) {
        this.toRenderTarget().method_1235(setViewport);
    }

    @Override
    public void bindRead() {
        RenderSystem.assertOnRenderThreadOrInit();
        GL30C.glBindFramebuffer((int)36008, (int)this.toRenderTarget().field_1476);
    }

    @Override
    public void bindDraw(boolean setViewport) {
        RenderSystem.assertOnRenderThreadOrInit();
        class_276 renderTarget = this.toRenderTarget();
        GL30C.glBindFramebuffer((int)36009, (int)renderTarget.field_1476);
        if (setViewport) {
            RenderSystem.viewport((int)0, (int)0, (int)renderTarget.field_1480, (int)renderTarget.field_1477);
        }
    }

    @Override
    public int getId() {
        return this.toRenderTarget().field_1476;
    }

    @Override
    public int getWidth() {
        return this.toRenderTarget().field_1482;
    }

    @Override
    public int getHeight() {
        return this.toRenderTarget().field_1481;
    }

    @Override
    public int getColorAttachments() {
        return 1;
    }

    @Override
    public int getClearMask() {
        return 0x4000 | (this.toRenderTarget().field_1478 ? 256 : 0);
    }

    @Override
    public int[] getDrawBuffers() {
        return new int[]{36064};
    }

    @Override
    public boolean hasColorAttachment(int attachment) {
        return attachment == 0;
    }

    @Override
    public boolean hasDepthAttachment() {
        return this.toRenderTarget().field_1478;
    }

    @Override
    public AdvancedFboAttachment getColorAttachment(int attachment) {
        Validate.isTrue((boolean)this.hasColorAttachment(attachment), (String)("Color attachment " + attachment + " does not exist."), (Object[])new Object[0]);
        return this.colorBuffer.get();
    }

    @Override
    public AdvancedFboAttachment getDepthAttachment() {
        Validate.isTrue((boolean)this.hasDepthAttachment(), (String)"Depth attachment does not exist.", (Object[])new Object[0]);
        return this.depthBuffer.get();
    }

    @Override
    public class_276 toRenderTarget() {
        return this.renderTargetSupplier.get();
    }

    public void free() {
        this.toRenderTarget().method_1238();
    }

    private static class AttachmentWrapper
    extends AdvancedFboTextureAttachment {
        private final AdvancedFbo parent;
        private final IntSupplier id;

        private AttachmentWrapper(AdvancedFbo parent, IntSupplier id, int type) {
            super(type, 0, 0, 0, 0, 0, 0, false, null);
            this.parent = parent;
            this.id = id;
        }

        @Override
        public void create() {
            throw new UnsupportedOperationException("Vanilla framebuffer attachments cannot be created");
        }

        @Override
        public void attach(int target, int attachment) {
            throw new UnsupportedOperationException("Vanilla framebuffer attachments cannot be attached");
        }

        public int method_4624() {
            return this.id.getAsInt();
        }

        @Override
        public int getWidth() {
            return this.parent.getWidth();
        }

        @Override
        public int getHeight() {
            return this.parent.getHeight();
        }

        @Override
        @NotNull
        public AdvancedFboTextureAttachment createCopy() {
            return new AttachmentWrapper(this.parent, this.id, this.getAttachmentType());
        }

        @Override
        public void free() {
            throw new UnsupportedOperationException("Vanilla framebuffer attachments cannot be deleted");
        }
    }
}

