/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.data.module;

import com.mojang.serialization.Codec;
import foundry.veil.api.quasar.data.ParticleModuleTypeRegistry;
import foundry.veil.api.quasar.data.module.ParticleModuleData;
import foundry.veil.api.quasar.data.module.collision.CollisionSubEmitterData;
import foundry.veil.api.quasar.data.module.collision.DieOnCollisionModuleData;
import foundry.veil.api.quasar.data.module.force.DragForceData;
import foundry.veil.api.quasar.data.module.force.GravityForceData;
import foundry.veil.api.quasar.data.module.force.PointAttractorForceData;
import foundry.veil.api.quasar.data.module.force.PointForceData;
import foundry.veil.api.quasar.data.module.force.VectorFieldForceData;
import foundry.veil.api.quasar.data.module.force.VortexForceData;
import foundry.veil.api.quasar.data.module.force.WindForceData;
import foundry.veil.api.quasar.data.module.init.BlockParticleModuleData;
import foundry.veil.api.quasar.data.module.init.InitSizeParticleModuleData;
import foundry.veil.api.quasar.data.module.init.InitSubEmitterModuleData;
import foundry.veil.api.quasar.data.module.init.InitialVelocityModuleData;
import foundry.veil.api.quasar.data.module.init.LightModuleData;
import foundry.veil.api.quasar.data.module.render.ColorParticleModuleData;
import foundry.veil.api.quasar.data.module.render.TrailParticleModuleData;
import foundry.veil.api.quasar.data.module.update.TickSizeParticleModuleData;
import foundry.veil.api.quasar.data.module.update.TickSubEmitterModuleData;
import foundry.veil.api.quasar.emitters.module.init.InitRandomRotationModuleData;
import org.jetbrains.annotations.ApiStatus;

@FunctionalInterface
public interface ModuleType<T extends ParticleModuleData> {
    public static final ModuleType<InitialVelocityModuleData> INITIAL_VELOCITY = ModuleType.registerInitModule("initial_velocity", InitialVelocityModuleData.CODEC);
    public static final ModuleType<ColorParticleModuleData> INIT_COLOR = ModuleType.registerInitModule("init_color", ColorParticleModuleData.CODEC);
    public static final ModuleType<InitSubEmitterModuleData> INIT_SUB_EMITTER = ModuleType.registerInitModule("init_sub_emitter", InitSubEmitterModuleData.CODEC);
    public static final ModuleType<InitSizeParticleModuleData> INIT_SIZE = ModuleType.registerInitModule("init_size", InitSizeParticleModuleData.CODEC);
    public static final ModuleType<InitRandomRotationModuleData> INIT_RANDOM_ROTATION = ModuleType.registerInitModule("init_random_rotation", InitRandomRotationModuleData.CODEC);
    public static final ModuleType<LightModuleData> LIGHT = ModuleType.registerInitModule("light", LightModuleData.CODEC);
    public static final ModuleType<BlockParticleModuleData> BLOCK_PARTICLE = ModuleType.registerInitModule("block", BlockParticleModuleData.CODEC);
    public static final ModuleType<TrailParticleModuleData> TRAIL = ModuleType.registerRenderModule("trail", TrailParticleModuleData.CODEC);
    public static final ModuleType<ColorParticleModuleData> COLOR = ModuleType.registerRenderModule("color", ColorParticleModuleData.CODEC);
    public static final ModuleType<TickSizeParticleModuleData> TICK_SIZE = ModuleType.registerUpdateModule("tick_size", TickSizeParticleModuleData.CODEC);
    public static final ModuleType<TickSubEmitterModuleData> TICK_SUB_EMITTER = ModuleType.registerUpdateModule("tick_sub_emitter", TickSubEmitterModuleData.CODEC);
    public static final ModuleType<DieOnCollisionModuleData> DIE_ON_COLLISION = ModuleType.registerUpdateModule("die_on_collision", DieOnCollisionModuleData.CODEC);
    public static final ModuleType<CollisionSubEmitterData> SUB_EMITTER_COLLISION = ModuleType.registerUpdateModule("sub_emitter_collision", CollisionSubEmitterData.CODEC);
    public static final ModuleType<GravityForceData> GRAVITY = ModuleType.registerUpdateModule("gravity", GravityForceData.CODEC);
    public static final ModuleType<VortexForceData> VORTEX = ModuleType.registerUpdateModule("vortex", VortexForceData.CODEC);
    public static final ModuleType<PointAttractorForceData> POINT_ATTRACTOR = ModuleType.registerUpdateModule("point_attractor", PointAttractorForceData.CODEC);
    public static final ModuleType<VectorFieldForceData> VECTOR_FIELD = ModuleType.registerUpdateModule("vector_field", VectorFieldForceData.CODEC);
    public static final ModuleType<DragForceData> DRAG = ModuleType.registerUpdateModule("drag", DragForceData.CODEC);
    public static final ModuleType<WindForceData> WIND = ModuleType.registerUpdateModule("wind", WindForceData.CODEC);
    public static final ModuleType<PointForceData> POINT = ModuleType.registerUpdateModule("point_force", PointForceData.CODEC);

    public Codec<T> codec();

    @ApiStatus.Internal
    public static void bootstrap() {
    }

    @ApiStatus.Internal
    public static <T extends ParticleModuleData> ModuleType<T> registerUpdateModule(String name, Codec<T> codec) {
        ModuleType<T> type = () -> codec;
        ParticleModuleTypeRegistry.registerUpdate(name, type);
        return type;
    }

    @ApiStatus.Internal
    public static <T extends ParticleModuleData> ModuleType<T> registerRenderModule(String name, Codec<T> codec) {
        ModuleType<T> type = () -> codec;
        ParticleModuleTypeRegistry.registerRender(name, type);
        return type;
    }

    @ApiStatus.Internal
    public static <T extends ParticleModuleData> ModuleType<T> registerInitModule(String name, Codec<T> codec) {
        ModuleType<T> type = () -> codec;
        ParticleModuleTypeRegistry.registerInit(name, type);
        return type;
    }
}

