/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.quasar.data.module.ParticleModuleData;
import foundry.veil.api.quasar.particle.RenderData;
import foundry.veil.api.quasar.particle.SpriteData;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_5381;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public record QuasarParticleData(boolean shouldCollide, boolean faceVelocity, float velocityStretchFactor, List<class_6880<ParticleModuleData>> initModules, List<class_6880<ParticleModuleData>> updateModules, List<class_6880<ParticleModuleData>> collisionModules, List<class_6880<ParticleModuleData>> forceModules, List<class_6880<ParticleModuleData>> renderModules, @Nullable SpriteData spriteData, RenderData.RenderStyle renderStyle) {
    public static final Codec<QuasarParticleData> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("should_collide", (Object)true).forGetter(QuasarParticleData::shouldCollide), (App)Codec.BOOL.optionalFieldOf("face_velocity", (Object)false).forGetter(QuasarParticleData::faceVelocity), (App)Codec.FLOAT.optionalFieldOf("velocity_stretch_factor", (Object)Float.valueOf(0.0f)).forGetter(QuasarParticleData::velocityStretchFactor), (App)ParticleModuleData.INIT_CODEC.listOf().optionalFieldOf("init_modules", Collections.emptyList()).forGetter(QuasarParticleData::initModules), (App)ParticleModuleData.UPDATE_CODEC.listOf().optionalFieldOf("update_modules", Collections.emptyList()).forGetter(QuasarParticleData::updateModules), (App)ParticleModuleData.UPDATE_CODEC.listOf().optionalFieldOf("collision_modules", Collections.emptyList()).forGetter(QuasarParticleData::collisionModules), (App)ParticleModuleData.UPDATE_CODEC.listOf().optionalFieldOf("forces", Collections.emptyList()).forGetter(QuasarParticleData::forceModules), (App)ParticleModuleData.RENDER_CODEC.listOf().optionalFieldOf("render_modules", Collections.emptyList()).forGetter(QuasarParticleData::renderModules), (App)SpriteData.CODEC.optionalFieldOf("sprite_data").forGetter(data -> Optional.ofNullable(data.spriteData())), (App)RenderData.RenderStyle.CODEC.optionalFieldOf("render_style", (Object)RenderData.RenderStyle.BILLBOARD).forGetter(QuasarParticleData::renderStyle)).apply((Applicative)instance, (shouldCollide, faceVelocity, velocityStretchFactor, initModules, updateModules, collisionModules, forceModules, renderModules, spriteData, renderStyle) -> new QuasarParticleData((boolean)shouldCollide, (boolean)faceVelocity, velocityStretchFactor.floatValue(), (List<class_6880<ParticleModuleData>>)initModules, (List<class_6880<ParticleModuleData>>)updateModules, (List<class_6880<ParticleModuleData>>)collisionModules, (List<class_6880<ParticleModuleData>>)forceModules, (List<class_6880<ParticleModuleData>>)renderModules, spriteData.orElse(null), (RenderData.RenderStyle)((Object)((Object)renderStyle)))));
    public static final Codec<class_6880<QuasarParticleData>> CODEC = class_5381.method_29749(QuasarParticles.PARTICLE_DATA, DIRECT_CODEC);

    public Stream<class_6880<ParticleModuleData>> allModules() {
        Stream.Builder<class_6880<ParticleModuleData>> builder = Stream.builder();
        for (class_6880<ParticleModuleData> initModule : this.initModules) {
            builder.add(initModule);
        }
        for (class_6880<ParticleModuleData> initModule : this.updateModules) {
            builder.add(initModule);
        }
        for (class_6880<ParticleModuleData> initModule : this.collisionModules) {
            builder.add(initModule);
        }
        for (class_6880<ParticleModuleData> initModule : this.forceModules) {
            builder.add(initModule);
        }
        for (class_6880<ParticleModuleData> initModule : this.renderModules) {
            builder.add(initModule);
        }
        return builder.build();
    }

    public class_2960 getRegistryId() {
        return QuasarParticles.registryAccess().method_30530(QuasarParticles.PARTICLE_DATA).method_10221((Object)this);
    }
}

