/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.program;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.joml.Matrix2f;
import org.joml.Matrix3f;
import org.joml.Matrix3x2f;
import org.joml.Matrix4f;
import org.joml.Matrix4x3f;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector4f;
import org.joml.Vector4i;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.MemoryStack;

public interface ShaderUniformAccess {
    public int getUniform(CharSequence var1);

    public int getUniformBlock(CharSequence var1);

    public int getProgram();

    default public float getFloat(CharSequence name) {
        return GL20C.glGetUniformf((int)this.getProgram(), (int)this.getUniform(name));
    }

    default public int getInt(CharSequence name) {
        return GL20C.glGetUniformi((int)this.getProgram(), (int)this.getUniform(name));
    }

    default public void getFloats(CharSequence name, float[] values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length);
            GL20C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i] = buffer.get(i);
            }
        }
    }

    default public void getVector(CharSequence name, Vector2f ... values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length * 2);
            GL20C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i].set(i * 2, buffer);
            }
        }
    }

    default public void getVector(CharSequence name, Vector3f ... values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length * 3);
            GL20C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i].set(i * 3, buffer);
            }
        }
    }

    default public void getVector(CharSequence name, Vector4f ... values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length * 4);
            GL20C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i].set(i * 4, buffer);
            }
        }
    }

    default public void getInts(CharSequence name, int[] values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length);
            GL20C.glGetUniformiv((int)this.getProgram(), (int)this.getUniform(name), (IntBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i] = buffer.get(i);
            }
        }
    }

    default public void getVector(CharSequence name, Vector2i ... values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length * 2);
            GL20C.glGetUniformiv((int)this.getProgram(), (int)this.getUniform(name), (IntBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i].set(i * 2, buffer);
            }
        }
    }

    default public void getVector(CharSequence name, Vector3i ... values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length * 3);
            GL20C.glGetUniformiv((int)this.getProgram(), (int)this.getUniform(name), (IntBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i].set(i * 3, buffer);
            }
        }
    }

    default public void getVector(CharSequence name, Vector4i ... values) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length * 4);
            GL20C.glGetUniformiv((int)this.getProgram(), (int)this.getUniform(name), (IntBuffer)buffer);
            for (int i = 0; i < values.length; ++i) {
                values[i].set(i * 4, buffer);
            }
        }
    }

    default public void getMatrix(CharSequence name, Matrix2f value) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(4);
            GL20C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            value.set(0, buffer);
        }
    }

    default public void getMatrix(CharSequence name, Matrix3f value) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(9);
            GL20C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            value.set(0, buffer);
        }
    }

    default public void getMatrix(CharSequence name, Matrix3x2f value) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(6);
            GL20C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            value.set(0, buffer);
        }
    }

    default public void getMatrix(CharSequence name, Matrix4f value) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(16);
            GL20C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            value.set(0, buffer);
        }
    }

    default public void getMatrix(CharSequence name, Matrix4x3f value) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(12);
            GL20C.glGetUniformfv((int)this.getProgram(), (int)this.getUniform(name), (FloatBuffer)buffer);
            value.set(0, buffer);
        }
    }
}

