/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader;

import com.mojang.logging.LogUtils;
import foundry.veil.Veil;
import foundry.veil.impl.client.render.shader.modifier.InputShaderModification;
import foundry.veil.impl.client.render.shader.modifier.ReplaceShaderModification;
import foundry.veil.impl.client.render.shader.modifier.ShaderModification;
import foundry.veil.impl.client.render.shader.modifier.SimpleShaderModification;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3544;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5912;
import net.minecraft.class_7654;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ShaderModificationManager
extends class_4080<Preparations> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final class_7654 MODIFIER_LISTER = new class_7654("pinwheel/shader_modifiers", ".txt");
    private static final Map<String, String> NEXT_STAGES = Map.of("vsh", "gsh", "gsh", "fsh");
    private static final Pattern OUT_PATTERN = Pattern.compile("out ");
    private Map<class_2960, List<ShaderModification>> shaders = Collections.emptyMap();
    private Map<ShaderModification, class_2960> names;

    public String applyModifiers(class_2960 shaderId, String source, int flags) {
        for (ShaderModification modification : this.getModifiers(shaderId)) {
            try {
                source = modification.inject(source, flags);
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to apply modification {} to shader instance {}. Skipping", new Object[]{this.names.get(modification), shaderId, e});
            }
        }
        return source;
    }

    public Collection<ShaderModification> getModifiers(class_2960 shaderId) {
        return this.shaders.getOrDefault(shaderId, Collections.emptyList());
    }

    @Nullable
    private class_2960 getNextStage(class_2960 shader, class_5912 resourceProvider) {
        String[] parts = shader.method_12832().split("\\.");
        String extension = parts[parts.length - 1].toLowerCase(Locale.ROOT);
        while (extension != null) {
            extension = NEXT_STAGES.get(extension);
            class_2960 nextShader = new class_2960(shader.method_12836(), shader.method_12832().substring(0, shader.method_12832().length() - 3) + extension);
            if (!resourceProvider.method_14486(nextShader).isPresent()) continue;
            return nextShader;
        }
        return null;
    }

    @NotNull
    protected Preparations prepare(@NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        HashMap<class_2960, List<ShaderModification>> modifiers = new HashMap<class_2960, List<ShaderModification>>();
        HashMap<ShaderModification, class_2960> names = new HashMap<ShaderModification, class_2960>();
        for (Map.Entry entry : MODIFIER_LISTER.method_45113(resourceManager).entrySet()) {
            class_2960 file = (class_2960)entry.getKey();
            class_2960 id = MODIFIER_LISTER.method_45115(file);
            try {
                String[] parts = id.method_12832().split("/", 2);
                if (parts.length < 2) {
                    LOGGER.warn("Ignoring shader modifier {}. Expected format to be located in shader_modifiers/domain/shader_path.vsh.txt", (Object)file);
                    continue;
                }
                class_2960 shaderId = new class_2960(parts[0], parts[1]);
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    ShaderModification modification = ShaderModification.parse(IOUtils.toString((Reader)reader), shaderId.method_12832().endsWith(".vsh"));
                    List modifications2 = modifiers.computeIfAbsent(shaderId, name -> new LinkedList());
                    if (modification instanceof ReplaceShaderModification) {
                        modifications2.clear();
                    }
                    if (modifications2.size() != 1 || !(modifications2.get(0) instanceof ReplaceShaderModification)) {
                        modifications2.add(modification);
                    }
                    names.put(modification, id);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, file, e});
            }
        }
        block8: for (Map.Entry entry : new HashMap(modifiers).entrySet()) {
            class_2960 nextStage = null;
            for (ShaderModification modification : (List)entry.getValue()) {
                SimpleShaderModification simpleMod;
                String output;
                if (!(modification instanceof SimpleShaderModification) || class_3544.method_15438((String)(output = (simpleMod = (SimpleShaderModification)modification).getOutput()))) continue;
                if (nextStage == null) {
                    nextStage = this.getNextStage((class_2960)entry.getKey(), (class_5912)resourceManager);
                }
                if (nextStage == null) continue block8;
                InputShaderModification input = new InputShaderModification(simpleMod.getPriority(), () -> OUT_PATTERN.matcher(simpleMod.fillPlaceholders(simpleMod.getOutput())).replaceAll("in "));
                modifiers.computeIfAbsent(nextStage, unused -> new LinkedList()).add(input);
                names.put(input, (class_2960)names.get(simpleMod));
            }
        }
        modifiers.values().forEach(modifications -> modifications.sort(Comparator.comparingInt(ShaderModification::getPriority).thenComparing(names::get)));
        return new Preparations(modifiers, names);
    }

    protected void apply(@NotNull Preparations preparations, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        this.shaders = Collections.unmodifiableMap(preparations.shaders);
        this.names = Collections.unmodifiableMap(preparations.names);
        LOGGER.info("Loaded {} shader modifications", (Object)this.names.size());
    }

    @ApiStatus.Internal
    public record Preparations(Map<class_2960, List<ShaderModification>> shaders, Map<ShaderModification, class_2960> names) {
    }
}

