/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.post;

import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.VeilClient;
import foundry.veil.api.CodecReloadListener;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.post.stage.CompositePostPipeline;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.pipeline.PostPipelineContext;
import foundry.veil.platform.services.VeilClientPlatform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;
import org.slf4j.Logger;

public class PostProcessingManager
extends CodecReloadListener<CompositePostPipeline>
implements NativeResource {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Comparator<ProfileEntry> PIPELINE_SORTER = Comparator.comparingInt(ProfileEntry::getPriority).reversed();
    private final PostPipelineContext context = new PostPipelineContext();
    private final List<ProfileEntry> activePipelines = new LinkedList<ProfileEntry>();
    private final Map<class_2960, PostPipeline> pipelines = new HashMap<class_2960, PostPipeline>();

    public PostProcessingManager() {
        super(CompositePostPipeline.CODEC, class_7654.method_45114((String)"pinwheel/post"));
    }

    public boolean isActive(class_2960 pipeline) {
        return this.activePipelines.stream().anyMatch(entry -> entry.pipeline.equals((Object)pipeline));
    }

    public boolean add(class_2960 pipeline) {
        return this.add(1000, pipeline);
    }

    public boolean add(int priority, class_2960 pipeline) {
        if (this.activePipelines.stream().anyMatch(entry -> entry.priority == priority && entry.pipeline.equals((Object)pipeline))) {
            return false;
        }
        this.remove(pipeline);
        this.activePipelines.add(new ProfileEntry(pipeline, priority));
        this.activePipelines.sort(PIPELINE_SORTER);
        return true;
    }

    public boolean remove(class_2960 pipeline) {
        return this.activePipelines.removeIf(entry -> entry.pipeline.equals((Object)pipeline));
    }

    @Nullable
    public PostPipeline getPipeline(class_2960 pipeline) {
        return this.pipelines.get(pipeline);
    }

    private void setup() {
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        RenderSystem.depthMask((boolean)false);
    }

    private void clear() {
        ShaderProgram.unbind();
        AdvancedFbo.unbind();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)true);
    }

    private void clearPipeline() {
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)false);
    }

    public void runPipeline() {
        if (this.activePipelines.isEmpty()) {
            return;
        }
        VeilClientPlatform platform = VeilClient.clientPlatform();
        this.context.begin();
        this.setup();
        int activeTexture = GlStateManager._getActiveTexture();
        this.activePipelines.sort(PIPELINE_SORTER);
        for (ProfileEntry entry : this.activePipelines) {
            class_2960 id = entry.getPipeline();
            PostPipeline pipeline = this.pipelines.get(id);
            if (pipeline == null) continue;
            platform.preVeilPostProcessing(id, pipeline, this.context);
            try {
                pipeline.apply(this.context);
                this.clearPipeline();
            }
            catch (Exception e) {
                LOGGER.error("Error running pipeline {}", (Object)id, (Object)e);
            }
            platform.postVeilPostProcessing(id, pipeline, this.context);
        }
        RenderSystem.activeTexture((int)activeTexture);
        this.clear();
        this.context.end();
    }

    public void runPipeline(PostPipeline pipeline) {
        this.context.begin();
        this.setup();
        int activeTexture = GlStateManager._getActiveTexture();
        try {
            pipeline.apply(this.context);
            this.clearPipeline();
        }
        catch (Exception e) {
            LOGGER.error("Error running pipeline {}", (Object)pipeline, (Object)e);
        }
        RenderSystem.activeTexture((int)activeTexture);
        this.clear();
        this.context.end();
    }

    private CompositePostPipeline loadPipeline(class_3298 resource) throws IOException {
        try (BufferedReader reader = resource.method_43039();){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            DataResult result = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (result.error().isPresent()) {
                throw new JsonSyntaxException(((DataResult.PartialResult)result.error().get()).message());
            }
            CompositePostPipeline compositePostPipeline = (CompositePostPipeline)result.result().orElseThrow();
            return compositePostPipeline;
        }
    }

    @Override
    @NotNull
    protected Map<class_2960, CompositePostPipeline> prepare(@NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        HashMap<class_2960, CompositePostPipeline> data = new HashMap<class_2960, CompositePostPipeline>();
        Map resources = this.converter.method_45116(resourceManager);
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            class_2960 id = this.converter.method_45115(location);
            if (((List)entry.getValue()).size() == 1) {
                try {
                    data.put(id, this.loadPipeline((class_3298)Iterables.getOnlyElement((Iterable)((Iterable)entry.getValue()))));
                }
                catch (Exception e) {
                    this.logger.error("Couldn't parse data file {} from {}", new Object[]{id, location, e});
                }
                continue;
            }
            List<CompositePostPipeline> pipelines = new ArrayList<CompositePostPipeline>(((List)entry.getValue()).size());
            for (class_3298 resource : (List)entry.getValue()) {
                try {
                    pipelines.add(this.loadPipeline(resource));
                }
                catch (Exception e) {
                    this.logger.error("Couldn't parse data file {} from {}", new Object[]{id, location, e});
                }
            }
            if (pipelines.isEmpty()) continue;
            if (pipelines.size() == 1) {
                data.put(id, (CompositePostPipeline)Iterables.getOnlyElement(pipelines));
                continue;
            }
            pipelines.sort(Comparator.comparingInt(CompositePostPipeline::getPriority));
            for (int i = 0; i < pipelines.size(); ++i) {
                CompositePostPipeline pipeline = (CompositePostPipeline)pipelines.get(i);
                if (!pipeline.isReplace()) continue;
                pipelines = pipelines.subList(0, i + 1);
                break;
            }
            data.put(id, new CompositePostPipeline((PostPipeline[])pipelines.toArray(CompositePostPipeline[]::new), Collections.emptyMap(), Collections.emptyMap()));
        }
        return data;
    }

    protected void apply(@NotNull Map<class_2960, CompositePostPipeline> data, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        this.pipelines.values().forEach(PostPipeline::free);
        this.pipelines.clear();
        this.pipelines.putAll(data);
        LOGGER.info("Loaded {} post pipelines", (Object)this.pipelines.size());
    }

    public void free() {
        this.pipelines.values().forEach(PostPipeline::free);
        this.pipelines.clear();
        this.context.free();
    }

    public PostPipeline.Context getContext() {
        return this.context;
    }

    @NotNull
    public Set<class_2960> getPipelines() {
        return this.pipelines.keySet();
    }

    public List<ProfileEntry> getActivePipelines() {
        this.activePipelines.sort(PIPELINE_SORTER);
        return this.activePipelines;
    }

    public static class ProfileEntry {
        private final class_2960 pipeline;
        private int priority;

        public ProfileEntry(class_2960 pipeline, int priority) {
            this.pipeline = pipeline;
            this.priority = priority;
        }

        public class_2960 getPipeline() {
            return this.pipeline;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProfileEntry that = (ProfileEntry)o;
            return this.priority == that.priority && Objects.equals(this.pipeline, that.pipeline);
        }

        public int hashCode() {
            int result = this.pipeline.hashCode();
            result = 31 * result + this.priority;
            return result;
        }
    }
}

