/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import foundry.veil.api.CodecReloadListener;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferDefinition;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1041;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_7654;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.NativeResource;
import org.slf4j.Logger;

public class FramebufferManager
extends CodecReloadListener<FramebufferDefinition>
implements NativeResource {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 MAIN = new class_2960("main");
    public static final Codec<class_2960> FRAMEBUFFER_CODEC = Codec.STRING.comapFlatMap(name -> {
        try {
            if (!name.contains(":")) {
                return DataResult.success((Object)new class_2960("temp", name));
            }
            return DataResult.success((Object)new class_2960(name));
        }
        catch (class_151 e) {
            return DataResult.error(() -> "Not a valid resource location: " + name + ". " + e.getMessage());
        }
    }, location -> "temp".equals(location.method_12836()) ? location.method_12832() : location.toString()).stable();
    private final Map<class_2960, FramebufferDefinition> framebufferDefinitions = new HashMap<class_2960, FramebufferDefinition>();
    private final Map<class_2960, AdvancedFbo> framebuffers = new HashMap<class_2960, AdvancedFbo>();
    private final Map<class_2960, AdvancedFbo> framebuffersView = Collections.unmodifiableMap(this.framebuffers);

    public FramebufferManager() {
        super(FramebufferDefinition.CODEC, class_7654.method_45114((String)"pinwheel/framebuffers"));
    }

    @ApiStatus.Internal
    public void resizeFramebuffers(int width, int height) {
        this.free();
        MolangRuntime runtime = (MolangRuntime)MolangRuntime.runtime().setQuery("screen_width", width).setQuery("screen_height", height).create();
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.framebufferDefinitions.forEach((name, definition) -> {
            try {
                AdvancedFbo fbo = definition.createBuilder(runtime).build(true);
                fbo.bindDraw(false);
                fbo.clear();
                this.framebuffers.put((class_2960)name, fbo);
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize framebuffer: {}", name, (Object)e);
            }
        });
        AdvancedFbo.unbind();
        this.framebuffers.put(MAIN, AdvancedFbo.getMainFramebuffer());
    }

    @ApiStatus.Internal
    public void clear() {
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.framebuffers.forEach((name, fbo) -> {
            if (MAIN.equals(name)) {
                return;
            }
            fbo.bindDraw(false);
            fbo.clear();
        });
        GL30.glBindFramebuffer((int)36160, (int)0);
    }

    @Nullable
    public AdvancedFbo getFramebuffer(class_2960 name) {
        return this.framebuffers.get(name);
    }

    public Map<class_2960, AdvancedFbo> getFramebuffers() {
        return this.framebuffersView;
    }

    protected void apply(@NotNull Map<class_2960, FramebufferDefinition> data, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        this.framebufferDefinitions.clear();
        this.framebufferDefinitions.putAll(data);
        class_1041 window = class_310.method_1551().method_22683();
        this.resizeFramebuffers(window.method_4489(), window.method_4506());
        LOGGER.info("Loaded {} framebuffers", (Object)this.framebufferDefinitions.size());
    }

    public void free() {
        this.framebuffers.remove(MAIN);
        this.framebuffers.values().forEach(NativeResource::free);
        this.framebuffers.clear();
    }
}

