/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light;

import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.deferred.light.InstancedLight;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.LightRenderer;
import foundry.veil.api.client.render.deferred.light.LightTypeRenderer;
import foundry.veil.ext.VertexBufferExtension;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import net.minecraft.class_287;
import net.minecraft.class_291;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public abstract class IndirectLightRenderer<T extends Light>
implements LightTypeRenderer<T> {
    protected final int lightSize;
    protected final int highResSize;
    protected final int lowResSize;
    protected int maxLights;
    private final class_291 vbo;
    private final int instancedVbo;
    private final int indirectVbo;

    public IndirectLightRenderer(int lightSize, int lowResSize) {
        this.lightSize = lightSize;
        this.maxLights = 100;
        this.vbo = new class_291(class_291.class_8555.field_44793);
        this.instancedVbo = GL15C.glGenBuffers();
        this.indirectVbo = GL15C.glGenBuffers();
        this.vbo.method_1353();
        this.vbo.method_1352(this.createMesh());
        VertexBufferExtension ext = (VertexBufferExtension)this.vbo;
        this.highResSize = ext.veil$getIndexCount() - lowResSize;
        this.lowResSize = lowResSize;
        GL15C.glBindBuffer((int)34962, (int)this.instancedVbo);
        GL15C.glBufferData((int)34962, (long)((long)this.maxLights * (long)this.lightSize), (int)35048);
        this.setupBufferState();
        GL15C.glBindBuffer((int)34962, (int)0);
        GL15C.glBindBuffer((int)36671, (int)this.indirectVbo);
        GL15C.glBufferData((int)36671, (long)((long)this.maxLights * 4L * 5L), (int)35040);
        GL15C.glBindBuffer((int)36671, (int)0);
        class_291.method_1354();
    }

    protected class_287.class_7433 createMesh() {
        return LightTypeRenderer.createQuad();
    }

    protected abstract void setupBufferState();

    protected abstract void setupRenderState(LightRenderer var1, List<T> var2);

    protected abstract void clearRenderState(LightRenderer var1, List<T> var2);

    protected boolean shouldDrawHighResolution(T light, CullFrustum frustum) {
        return true;
    }

    private void updateAllLights(List<T> lights) {
        ByteBuffer dataBuffer = MemoryUtil.memAlloc((int)(lights.size() * this.lightSize));
        int pointer = 0;
        for (Light light : lights) {
            light.clean();
            dataBuffer.position(pointer++ * this.lightSize);
            ((InstancedLight)((Object)light)).store(dataBuffer);
        }
        if (pointer > 0) {
            dataBuffer.rewind();
            GL15C.glBufferSubData((int)34962, (long)0L, (ByteBuffer)dataBuffer);
        }
        MemoryUtil.memFree((Buffer)dataBuffer);
    }

    @Override
    public void renderLights(LightRenderer lightRenderer, List<T> lights, Set<T> removedLights, CullFrustum frustum) {
        int i;
        ByteBuffer buffer;
        MemoryStack stack;
        VertexBufferExtension ext = (VertexBufferExtension)this.vbo;
        this.vbo.method_1353();
        GL15C.glBindBuffer((int)34962, (int)this.instancedVbo);
        GL15C.glBindBuffer((int)36671, (int)this.indirectVbo);
        boolean rebuild = false;
        if (lights.size() > this.maxLights || this.maxLights > lights.size() * 2) {
            rebuild = true;
            this.maxLights = (int)Math.max(Math.ceil((double)this.maxLights / 2.0), (double)lights.size() * 1.5);
            GL15C.glBufferData((int)34962, (long)((long)this.maxLights * (long)this.lightSize), (int)35048);
            GL15C.glBufferData((int)36671, (long)((long)this.maxLights * 4L * 5L), (int)35040);
            stack = MemoryStack.stackPush();
            try {
                buffer = stack.calloc(20);
                buffer.putInt(0, ext.veil$getIndexCount());
                buffer.putInt(4, 1);
                for (i = 0; i < this.maxLights; ++i) {
                    GL15C.glBufferSubData((int)36671, (long)((long)(i * 4) * 5L), (ByteBuffer)buffer);
                }
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        if (rebuild || !removedLights.isEmpty()) {
            this.updateAllLights(lights);
        } else {
            stack = MemoryStack.stackPush();
            try {
                buffer = stack.malloc(this.lightSize);
                for (i = 0; i < lights.size(); ++i) {
                    Light light = (Light)lights.get(i);
                    if (!light.isDirty()) continue;
                    light.clean();
                    ((InstancedLight)((Object)light)).store(buffer);
                    buffer.rewind();
                    GL15C.glBufferSubData((int)34962, (long)((long)i * (long)this.lightSize), (ByteBuffer)buffer);
                }
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        int count = 0;
        try (MemoryStack stack2 = MemoryStack.stackPush();){
            ByteBuffer buffer2 = stack2.malloc(this.lowResSize > 0 ? 20 : 4);
            int index = 0;
            for (Light light : lights) {
                if (light.isVisible(frustum)) {
                    if (this.lowResSize > 0) {
                        boolean highRes = this.shouldDrawHighResolution(light, frustum);
                        buffer2.putInt(0, highRes ? this.highResSize : this.lowResSize);
                        buffer2.putInt(4, 1);
                        buffer2.putInt(8, !highRes ? this.highResSize : 0);
                        buffer2.putInt(12, 0);
                        buffer2.putInt(16, index);
                        GL15C.glBufferSubData((int)36671, (long)((long)(count * 4) * 5L), (ByteBuffer)buffer2);
                    } else {
                        buffer2.putInt(0, index);
                        GL15C.glBufferSubData((int)36671, (long)((long)(count * 4) * 5L + 16L), (ByteBuffer)buffer2);
                    }
                    ++count;
                }
                ++index;
            }
        }
        if (count > 0) {
            this.setupRenderState(lightRenderer, lights);
            lightRenderer.applyShader();
            ext.veil$drawIndirect(0L, count, 0);
            this.clearRenderState(lightRenderer, lights);
        }
        GL15C.glBindBuffer((int)34962, (int)0);
        GL15C.glBindBuffer((int)36671, (int)0);
        class_291.method_1354();
    }

    public void free() {
        this.vbo.close();
        GL15C.glDeleteBuffers((int)this.instancedVbo);
        GL15C.glDeleteBuffers((int)this.indirectVbo);
    }
}

