/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.registry;

import foundry.veil.api.client.pose.ExtendedPose;
import foundry.veil.api.client.util.Easings;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1835;
import net.minecraft.class_310;
import net.minecraft.class_572;
import net.minecraft.class_630;

public class PoseRegistry {
    public static Map<Predicate<class_1792>, ExtendedPose> poses = new HashMap<Predicate<class_1792>, ExtendedPose>();
    public static ExtendedPose BOW = PoseRegistry.registerPose((class_1792 item) -> item instanceof class_1753, new ExtendedPose(){

        @Override
        public void poseMainHand(class_630 mainHand) {
            float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
            mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
            mainHand.field_3654 *= mult;
        }

        @Override
        public void poseOffHand(class_630 offHand) {
            float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
            mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
            offHand.field_3654 *= mult;
        }
    });
    public static ExtendedPose CROSSBOW = PoseRegistry.registerPose((class_1792 i) -> i instanceof class_1764, new ExtendedPose(){

        @Override
        public void poseMainHand(class_630 mainHand) {
            float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
            mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
            mainHand.field_3654 *= mult;
        }

        @Override
        public void poseOffHand(class_630 offHand) {
            float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
            mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
            offHand.field_3654 *= mult;
        }
    });
    public static ExtendedPose TRIDENT = PoseRegistry.registerPose((class_1792 i) -> i instanceof class_1835, new ExtendedPose(){
        float headXRot = 0.0f;
        float headYRot = 0.0f;
        public final boolean forceRenderOffhand = true;

        @Override
        public void pose(class_572<?> model) {
            super.pose(model);
            this.headXRot = model.field_3398.field_3654;
            this.headYRot = model.field_3398.field_3675;
        }

        @Override
        public void poseBody(class_630 body) {
            body.field_3654 = -0.75f + Math.max(0.0f, 1.5707964f + this.headXRot) / 2.0f;
        }

        @Override
        public void poseMainHand(class_630 mainHand) {
            if (this.data.swapped) {
                mainHand.field_3675 = 0.1f + this.headYRot;
                mainHand.field_3654 = -1.5707964f + this.headXRot;
                float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
                mainHand.field_3654 *= mult;
                mainHand.field_3675 *= mult;
            } else {
                mainHand.field_3654 = -1.5707964f + this.headXRot - 1.5f;
                float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
                if (!class_310.method_1551().field_1724.method_5715()) {
                    mainHand.field_3654 *= mult;
                    return;
                }
                mainHand.field_3654 *= mult / 2.0f;
                mainHand.field_3675 = 1.25f + this.headYRot;
                if (this.data.useTime >= this.data.maxUseTime) {
                    mainHand.field_3675 += (float)(Math.sin((this.data.useTime + this.data.partialTick) / 2.0f) * 0.5);
                    mainHand.field_3654 += (float)(Math.cos((this.data.useTime + this.data.partialTick) / 2.0f) * 0.5);
                }
            }
        }

        @Override
        public void poseOffHand(class_630 offHand) {
            if (this.data.swapped) {
                offHand.field_3654 = -1.5707964f + this.headXRot - 1.5f;
                float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
                if (!class_310.method_1551().field_1724.method_5715()) {
                    offHand.field_3654 *= mult;
                    return;
                }
                offHand.field_3654 *= mult / 2.0f;
                offHand.field_3675 = 1.25f + this.headYRot;
                if (this.data.useTime >= this.data.maxUseTime) {
                    offHand.field_3675 += (float)(Math.sin((this.data.useTime + this.data.partialTick) / 2.0f) * 0.5);
                    offHand.field_3654 += (float)(Math.cos((this.data.useTime + this.data.partialTick) / 2.0f) * 0.5);
                }
            } else {
                offHand.field_3675 = 0.1f + this.headYRot;
                offHand.field_3654 = -1.5707964f + this.headXRot;
                float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
                offHand.field_3654 *= mult;
                offHand.field_3675 *= mult;
            }
        }
    });

    public static ExtendedPose registerPose(class_1792 item, ExtendedPose pose) {
        poses.put(i -> i.equals(item), pose);
        return pose;
    }

    public static ExtendedPose registerPose(Predicate<class_1792> itemPredicate, ExtendedPose pose) {
        poses.put(itemPredicate, pose);
        return pose;
    }
}

