/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.graveyard.skeleton;

import foundry.veil.api.client.graveyard.render.mesh.ModelMesh;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class InterpolatedBone {
    private float x;
    private float y;
    private float z;
    private float pX;
    private float pY;
    private float pZ;
    public Quaternionf rotation;
    public Quaternionf pRotation;
    protected Quaternionf currentRotation;
    public float xSize;
    public float ySize;
    public float zSize;
    public float pXSize;
    public float pYSize;
    public float pZSize;
    public float initialX;
    public float initialY;
    public float initialZ;
    public Quaternionf initialRotation;
    public float initialXSize;
    public float initialYSize;
    public float initialZSize;
    @Nullable
    public InterpolatedBone parent;
    public List<InterpolatedBone> children;
    public final String identifier;
    public boolean shouldRender = true;
    public List<InterpolatedBone> parentChain;

    public InterpolatedBone(String identifier) {
        this.identifier = identifier;
        this.rotation = new Quaternionf();
        this.pRotation = new Quaternionf();
        this.currentRotation = new Quaternionf();
        this.initialRotation = new Quaternionf();
        this.xSize = 1.0f;
        this.ySize = 1.0f;
        this.zSize = 1.0f;
        this.pXSize = 1.0f;
        this.pYSize = 1.0f;
        this.pZSize = 1.0f;
        this.initialXSize = 1.0f;
        this.initialYSize = 1.0f;
        this.initialZSize = 1.0f;
        this.children = new ArrayList<InterpolatedBone>();
        this.parentChain = new ArrayList<InterpolatedBone>();
    }

    public void setInitialTransform(float x, float y, float z, Quaternionf rotation) {
        this.initialX = x;
        this.initialY = y;
        this.initialZ = z;
        this.x = this.initialX;
        this.y = this.initialY;
        this.z = this.initialZ;
        this.pX = this.initialX;
        this.pY = this.initialY;
        this.pZ = this.initialZ;
        this.initialRotation.set((Quaternionfc)rotation);
        this.rotation.set((Quaternionfc)this.initialRotation);
        this.pRotation.set((Quaternionfc)this.initialRotation);
        this.currentRotation.set((Quaternionfc)this.initialRotation);
    }

    public void reset() {
        this.x = this.initialX;
        this.y = this.initialY;
        this.z = this.initialZ;
        this.rotation.set((Quaternionfc)this.initialRotation);
        this.xSize = this.initialXSize;
        this.ySize = this.initialYSize;
        this.zSize = this.initialZSize;
    }

    protected void updatePreviousPosition() {
        this.pX = this.x;
        this.pY = this.y;
        this.pZ = this.z;
        this.pRotation.set((Quaternionfc)this.rotation);
        this.pXSize = this.xSize;
        this.pYSize = this.ySize;
        this.pZSize = this.zSize;
    }

    public void setGlobalSpaceRotation(Quaternionf globalSpaceRotation) {
        Quaternionf parentRotation = new Quaternionf();
        for (InterpolatedBone bone : this.parentChain) {
            parentRotation.mul((Quaternionfc)bone.rotation);
        }
        parentRotation.difference((Quaternionfc)globalSpaceRotation, this.rotation);
    }

    protected void tick(float deltaTime) {
    }

    public void transform(class_4587 pPoseStack, float partialTick) {
        pPoseStack.method_46416(class_3532.method_16439((float)partialTick, (float)this.pX, (float)this.x), class_3532.method_16439((float)partialTick, (float)this.pY, (float)this.y), class_3532.method_16439((float)partialTick, (float)this.pZ, (float)this.z));
        this.currentRotation = this.pRotation.slerp((Quaternionfc)this.rotation, partialTick, this.currentRotation);
        this.currentRotation.normalize();
        pPoseStack.method_22907(this.currentRotation);
        pPoseStack.method_22905(class_3532.method_16439((float)partialTick, (float)this.pXSize, (float)this.xSize), class_3532.method_16439((float)partialTick, (float)this.pYSize, (float)this.ySize), class_3532.method_16439((float)partialTick, (float)this.pZSize, (float)this.zSize));
    }

    public <T extends InterpolatedSkeleton> void render(Map<String, ModelMesh> meshes, float partialTick, class_4587 poseStack, class_4588 pVertexConsumer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha, boolean drawChildren) {
        if (!this.shouldRender) {
            return;
        }
        poseStack.method_22903();
        ModelMesh mesh = meshes.get(this.identifier);
        this.transform(poseStack, partialTick);
        if (mesh != null) {
            mesh.render(this, poseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        }
        if (drawChildren) {
            for (InterpolatedBone child : this.children) {
                child.render(meshes, partialTick, poseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha, true);
            }
        }
        poseStack.method_22909();
    }

    public void addChild(InterpolatedBone children) {
        if (children.parent != null) {
            children.parent.children.remove(children);
        }
        this.children.add(children);
        children.parent = this;
    }

    public void setParent(InterpolatedBone parent) {
        this.parent = parent;
        parent.children.add(this);
    }

    public Matrix4f getModelSpaceTransformMatrix(class_4587 pPoseStack, float partialTick) {
        InterpolatedBone parent = this.parent;
        if (parent != null) {
            parent.getModelSpaceTransformMatrix(pPoseStack, partialTick);
        }
        this.transform(pPoseStack, partialTick);
        return pPoseStack.method_23760().method_23761();
    }

    public void rotate(float angle, class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                this.rotation.rotateX(angle);
                break;
            }
            case field_11052: {
                this.rotation.rotateY(angle);
                break;
            }
            case field_11051: {
                this.rotation.rotateZ(angle);
            }
        }
    }
}

