/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.graveyard.render;

import foundry.veil.api.client.graveyard.AnimationProperties;
import foundry.veil.api.client.graveyard.render.InterpolatedEntityRenderLayer;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeleton;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeletonParent;
import foundry.veil.api.client.graveyard.skeleton.SkeletonFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_922;

public abstract class InterpolatedEntityRenderer<T extends class_1309, S extends InterpolatedSkeleton>
extends class_897<T> {
    protected final SkeletonFactory<S> modelFactory;
    private final List<InterpolatedEntityRenderLayer<T, S>> layers = new ArrayList<InterpolatedEntityRenderLayer<T, S>>();

    protected InterpolatedEntityRenderer(class_5617.class_5618 pContext, SkeletonFactory<S> modelFactory, float shadowRadius) {
        super(pContext);
        this.modelFactory = modelFactory;
        this.field_4673 = shadowRadius;
    }

    public void setupModelFactory(T parent) {
    }

    public final void createSkeleton(T parent) {
        this.setupModelFactory(parent);
        ((InterpolatedSkeletonParent)parent).setSkeleton((InterpolatedSkeleton)this.modelFactory.create());
    }

    public final boolean addLayer(InterpolatedEntityRenderLayer<T, S> layer) {
        return this.layers.add(layer);
    }

    public void render(T entity, float yaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        poseStack.method_22903();
        poseStack.method_22905(0.0625f, 0.0625f, 0.0625f);
        this.setupRotations(entity, poseStack, (float)((class_1309)entity).field_6012 + partialTicks, partialTicks);
        class_310 minecraft = class_310.method_1551();
        boolean invisible = entity.method_5767();
        boolean isSpectatorTransparent = !invisible && !entity.method_5756((class_1657)minecraft.field_1724);
        boolean glowing = minecraft.method_27022(entity);
        class_1921 rendertype = this.getRenderType(entity, invisible, isSpectatorTransparent, glowing);
        if (rendertype != null) {
            this.renderModel(entity, partialTicks, poseStack, buffer, packedLight);
        }
        InterpolatedSkeleton skeleton = ((InterpolatedSkeletonParent)entity).getSkeleton();
        if (!entity.method_7325()) {
            for (InterpolatedEntityRenderLayer<T, S> layer : this.layers) {
                if (skeleton == null) continue;
                layer.render(poseStack, buffer, packedLight, entity, skeleton, partialTicks);
            }
        }
        if (skeleton != null) {
            skeleton.renderDebug((InterpolatedSkeletonParent)entity, poseStack, buffer, partialTicks);
        }
        poseStack.method_22909();
        super.method_3936(entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    public void renderModel(T pEntity, float pPartialTicks, class_4587 poseStack, class_4597 pBuffer, int pPackedLight) {
        InterpolatedSkeleton skeleton = ((InterpolatedSkeletonParent)pEntity).getSkeleton();
        if (skeleton == null) {
            return;
        }
        class_4588 vertexconsumer = pBuffer.getBuffer(this.getRenderType(pEntity));
        int packedOverlay = class_922.method_23622(pEntity, (float)0.0f);
        skeleton.render(poseStack, vertexconsumer, pPackedLight, packedOverlay, pPartialTicks, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public abstract class_1921 getRenderType(T var1);

    protected class_1921 getRenderType(T pLivingEntity, boolean pBodyVisible, boolean pTranslucent, boolean pGlowing) {
        class_2960 resourcelocation = this.method_3931((class_1297)pLivingEntity);
        if (pTranslucent) {
            return class_1921.method_29379((class_2960)resourcelocation);
        }
        if (pBodyVisible) {
            return this.getRenderType(pLivingEntity);
        }
        return pGlowing ? class_1921.method_23287((class_2960)resourcelocation) : null;
    }

    protected void setupRotations(T pEntityLiving, class_4587 pMatrixStack, float pAgeInTicks, float pPartialTicks) {
        if (((class_1309)pEntityLiving).field_6213 > 0) {
            float deathTime = ((float)((class_1309)pEntityLiving).field_6213 + pPartialTicks - 1.0f) / 20.0f * 1.6f;
            if ((deathTime = class_3532.method_15355((float)deathTime)) > 1.0f) {
                deathTime = 1.0f;
            }
            pMatrixStack.method_22907(class_7833.field_40718.rotationDegrees(deathTime * this.getFlipDegrees(pEntityLiving)));
        } else if (pEntityLiving.method_6123()) {
            pMatrixStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f - pEntityLiving.method_36455()));
            pMatrixStack.method_22907(class_7833.field_40716.rotationDegrees(((float)((class_1309)pEntityLiving).field_6012 + pPartialTicks) * -75.0f));
        } else if (class_922.method_38563(pEntityLiving)) {
            pMatrixStack.method_22904(0.0, (double)(pEntityLiving.method_17682() + 0.1f), 0.0);
            pMatrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        }
        if (pEntityLiving.method_32314()) {
            pMatrixStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_15362((float)((float)((class_1309)pEntityLiving).field_6012 * 3.25f)) * (float)Math.PI * 0.4f));
        }
    }

    protected float getFlipDegrees(T entity) {
        return 90.0f;
    }

    public static void tick(List<InterpolatedSkeletonParent> entitiesToRender) {
        for (InterpolatedSkeletonParent interpolatedSkeletonParent : entitiesToRender) {
            AnimationProperties properties = new AnimationProperties();
            interpolatedSkeletonParent.getSkeleton().addAnimationProperties(properties, interpolatedSkeletonParent);
            interpolatedSkeletonParent.getSkeleton().tick(properties);
        }
    }
}

