/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.editor;

import foundry.veil.api.client.editor.Editor;
import foundry.veil.impl.client.editor.DeferredEditor;
import foundry.veil.impl.client.editor.DeviceInfoViewer;
import foundry.veil.impl.client.editor.ExampleEditor;
import foundry.veil.impl.client.editor.LightEditor;
import foundry.veil.impl.client.editor.OpenCLEditor;
import foundry.veil.impl.client.editor.PostEditor;
import foundry.veil.impl.client.editor.ShaderEditor;
import foundry.veil.impl.client.editor.TextureEditor;
import imgui.ImGui;
import imgui.type.ImBoolean;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import net.minecraft.class_3902;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EditorManager
implements class_3302 {
    private final Map<Editor, ImBoolean> editors = new TreeMap<Editor, ImBoolean>(Comparator.comparing(Editor::getDisplayName));
    private boolean enabled;

    @ApiStatus.Internal
    public EditorManager(class_3304 resourceManager) {
        this.add(new ExampleEditor());
        this.add(new PostEditor());
        this.add(new ShaderEditor());
        this.add(new TextureEditor());
        this.add(new OpenCLEditor());
        this.add(new DeviceInfoViewer());
        this.add(new DeferredEditor());
        this.add(new LightEditor());
        resourceManager.method_14477((class_3302)this);
    }

    @ApiStatus.Internal
    public void render() {
        ImBoolean enabled;
        Editor editor;
        if (!this.enabled) {
            return;
        }
        if (ImGui.beginMainMenuBar()) {
            if (ImGui.beginMenu("Editor")) {
                for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
                    editor = entry.getKey();
                    enabled = entry.getValue();
                    ImGui.beginDisabled(!editor.isEnabled());
                    if (ImGui.menuItem(editor.getDisplayName(), null, enabled.get())) {
                        if (!enabled.get()) {
                            this.show(editor);
                        } else {
                            this.hide(editor);
                        }
                    }
                    ImGui.endDisabled();
                }
                ImGui.endMenu();
            }
            for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
                editor = entry.getKey();
                if (!entry.getValue().get() || !editor.isMenuBarEnabled()) continue;
                ImGui.separator();
                ImGui.textColored(-5592406, editor.getDisplayName());
                editor.renderMenuBar();
            }
            ImGui.endMainMenuBar();
        }
        for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
            editor = entry.getKey();
            enabled = entry.getValue();
            if (!editor.isEnabled()) {
                enabled.set(false);
            }
            if (!enabled.get()) continue;
            editor.render();
        }
    }

    @ApiStatus.Internal
    public void renderLast() {
        if (!this.enabled) {
            return;
        }
        for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
            Editor editor = entry.getKey();
            ImBoolean enabled = entry.getValue();
            if (!enabled.get()) continue;
            editor.renderLast();
        }
    }

    public void show(Editor editor) {
        ImBoolean enabled = this.editors.get(editor);
        if (enabled != null && !enabled.get()) {
            editor.onShow();
            enabled.set(true);
        }
    }

    public void hide(Editor editor) {
        ImBoolean enabled = this.editors.get(editor);
        if (enabled != null && enabled.get()) {
            editor.onHide();
            enabled.set(false);
        }
    }

    public boolean isVisible(Editor editor) {
        ImBoolean visible = this.editors.get(editor);
        return visible != null && visible.get();
    }

    public synchronized void add(Editor editor) {
        this.editors.computeIfAbsent(editor, unused -> new ImBoolean());
    }

    public synchronized void remove(Editor editor) {
        this.hide(editor);
        this.editors.remove(editor);
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @NotNull
    public CompletableFuture<Void> method_25931(final @NotNull class_3302.class_4045 preparationBarrier, @NotNull class_3300 resourceManager, @NotNull class_3695 prepareProfiler, @NotNull class_3695 applyProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        class_3302[] listeners = (class_3302[])this.editors.keySet().stream().filter(editor -> editor instanceof class_3302).toArray(class_3302[]::new);
        if (listeners.length == 0) {
            return preparationBarrier.method_18352(null);
        }
        if (listeners.length == 1) {
            return listeners[0].method_25931(preparationBarrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor);
        }
        final CompletableFuture allComplete = new CompletableFuture();
        final HashSet<class_3302> preparingListeners = new HashSet<class_3302>(List.of(listeners));
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(listeners.length);
        for (final class_3302 listener : listeners) {
            class_3302.class_4045 barrier = new class_3302.class_4045(){

                public <T> CompletableFuture<T> method_18352(T value) {
                    preparingListeners.remove(listener);
                    if (preparingListeners.isEmpty()) {
                        preparationBarrier.method_18352(null).thenRun(() -> allComplete.complete(class_3902.field_17274));
                    }
                    return allComplete.thenApply(unused -> value);
                }
            };
            futures.add(listener.method_25931(barrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }
}

