/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.anim;

import foundry.veil.api.client.anim.Frame;
import foundry.veil.api.client.anim.Keyframe;
import java.util.ArrayList;
import java.util.List;

public class Path {
    List<Frame> frames;
    boolean loop;
    boolean pingPong = false;
    Frame currentFrame;

    public Path(List<Frame> frames, boolean loop) {
        this.frames = frames;
        this.loop = loop;
        this.currentFrame = frames.get(0);
        this.populateFrames();
    }

    public Path(List<Frame> frames, boolean loop, boolean bezier) {
        this.frames = frames;
        this.loop = loop;
        this.currentFrame = frames.get(0);
        if (bezier) {
            this.populateFramesBezier();
        } else {
            this.populateFrames();
        }
    }

    public Keyframe getCurrentKeyframeAtProgress(float progress) {
        Frame frame;
        int index = this.frames.indexOf(this.frameAtProgress(progress));
        if (index == -1) {
            for (int i = 0; i < this.frames.size(); ++i) {
                if (!(this.frames.get(i) instanceof Keyframe)) continue;
                index = i;
                break;
            }
        }
        if ((frame = this.frames.get(index)) instanceof Keyframe) {
            return (Keyframe)frame;
        }
        return null;
    }

    public Keyframe getKeyframeBefore(Frame frame) {
        int index = this.frames.indexOf(frame);
        if (index == -1) {
            return null;
        }
        for (int i = index; i >= 0; --i) {
            if (!(this.frames.get(i) instanceof Keyframe)) continue;
            return (Keyframe)this.frames.get(i);
        }
        return null;
    }

    private void populateFrames() {
        ArrayList<Frame> newFrames = new ArrayList<Frame>();
        for (int i = 0; i < this.frames.size(); ++i) {
            Frame frame = this.frames.get(i);
            newFrames.add(frame);
            if (frame instanceof Keyframe) {
                for (int j = 0; j < ((Keyframe)frame).getDuration(); ++j) {
                    int frameIndex = i + 1 >= this.frames.size() ? (this.loop ? 0 : i) : i + 1;
                    newFrames.add(frame.interpolate(this.frames.get(frameIndex), (float)j / (float)((Keyframe)frame).duration, ((Keyframe)frame).getEasing()));
                }
                continue;
            }
            newFrames.add(frame);
        }
        this.frames = newFrames;
    }

    private void populateFramesBezier() {
        ArrayList<Frame> newFrames = new ArrayList<Frame>();
        for (int i = 0; i < this.frames.size(); ++i) {
            Frame frame = this.frames.get(i);
            newFrames.add(frame);
            if (frame instanceof Keyframe) {
                for (int j = 0; j < ((Keyframe)frame).getDuration(); ++j) {
                    int frameIndex = i + 1 >= this.frames.size() ? (this.loop ? 0 : i) : i + 1;
                    newFrames.add(frame.bezierInterpolate(this.frames.get(frameIndex), (float)j / (float)((Keyframe)frame).duration, ((Keyframe)frame).getEasing()));
                }
                continue;
            }
            newFrames.add(frame);
        }
        this.frames = newFrames;
    }

    public int duration() {
        int duration = 0;
        for (Frame frame : this.frames) {
            if (frame instanceof Keyframe) {
                duration += ((Keyframe)frame).getDuration();
                continue;
            }
            ++duration;
        }
        return duration;
    }

    void reverse() {
        ArrayList<Frame> newFrames = new ArrayList<Frame>();
        for (int i = this.frames.size() - 1; i >= 0; --i) {
            Frame frame = this.frames.get(i);
            if (frame instanceof Keyframe) {
                newFrames.add(frame);
                for (int j = ((Keyframe)frame).getDuration() - 1; j >= 0; --j) {
                    int frameIndex = i - 1 < 0 ? (this.loop ? this.frames.size() - 1 : i) : i - 1;
                    newFrames.add(frame.interpolate(this.frames.get(frameIndex), (float)j / (float)((Keyframe)frame).duration, ((Keyframe)frame).getEasing()));
                }
                continue;
            }
            newFrames.add(frame);
        }
        this.frames = newFrames;
    }

    public void next() {
        if (this.pingPong) {
            if (this.frames.indexOf(this.currentFrame) == this.frames.size() - 1) {
                this.reverse();
            } else if (this.frames.indexOf(this.currentFrame) == 0) {
                this.reverse();
            }
        }
        this.currentFrame = this.frames.get(this.frames.indexOf(this.currentFrame) + 1 >= this.frames.size() ? (this.loop ? 0 : this.frames.size() - 1) : this.frames.indexOf(this.currentFrame) + 1);
    }

    public void previous() {
        if (this.pingPong) {
            if (this.frames.indexOf(this.currentFrame) == this.frames.size() - 1) {
                this.reverse();
            } else if (this.frames.indexOf(this.currentFrame) == 0) {
                this.reverse();
            }
        }
        this.currentFrame = this.frames.get(this.frames.indexOf(this.currentFrame) - 1 < 0 ? (this.loop ? this.frames.size() - 1 : 0) : this.frames.indexOf(this.currentFrame) - 1);
    }

    public void reset() {
        this.currentFrame = this.frames.get(0);
    }

    public Frame frameAtProgress(float progress) {
        return this.frames.get((int)((float)this.frames.size() * progress));
    }

    public Frame getCurrentFrame() {
        return this.currentFrame;
    }
}

