/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.emitters.modules.particle.update.fields;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.util.FastNoiseLite;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public record VectorField(FastNoiseLite noise, float strength) {
    public static Codec<VectorField> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FastNoiseLite.CODEC.fieldOf("noise").forGetter(VectorField::noise), (App)Codec.FLOAT.fieldOf("strength").forGetter(VectorField::strength)).apply((Applicative)instance, VectorField::new));

    public Vector3d getVector(Vector3dc position, Vector3d result) {
        float x = (float)position.x();
        float y = (float)position.y();
        float z = (float)position.z();
        float xNoise = this.noise.GetNoise(x, y, z);
        float yNoise = this.noise.GetNoise(x + 100.0f, y + 100.0f, z + 100.0f);
        float zNoise = this.noise.GetNoise(x + 200.0f, y + 200.0f, z + 200.0f);
        return result.set((double)xNoise, (double)yNoise, (double)zNoise).normalize((double)this.strength);
    }

    public Vector3d getVector(Vector3dc position) {
        return this.getVector(position, new Vector3d());
    }
}

