/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.emitters.modules.particle.force;

import foundry.veil.quasar.client.particle.QuasarParticle;
import foundry.veil.quasar.emitters.modules.particle.ForceParticleModule;
import foundry.veil.quasar.emitters.modules.particle.force.PositionedForce;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public abstract class SimplePositionedForce
implements ForceParticleModule,
PositionedForce {
    protected final Vector3d position;
    protected boolean localPosition;
    private final Vector3d tempPos;

    protected SimplePositionedForce(Vector3d position, boolean localPosition) {
        this.position = position;
        this.localPosition = localPosition;
        this.tempPos = new Vector3d();
    }

    protected SimplePositionedForce(Vector3dc position, boolean localPosition) {
        this(new Vector3d(position), localPosition);
    }

    protected Vector3d getDeltaPosition(QuasarParticle particle) {
        if (this.localPosition) {
            return this.position.add((Vector3dc)particle.getParent().getPosition(), this.tempPos).sub((Vector3dc)particle.getPosition());
        }
        return this.position.sub((Vector3dc)particle.getPosition(), this.tempPos);
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public boolean isLocalPosition() {
        return this.localPosition;
    }

    @Override
    public void setForceOrigin(double x, double y, double z) {
        this.position.set(x, y, z);
        this.localPosition = false;
    }
}

