/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.emitters.modules.emitter.settings.shapes;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.quasar.emitters.modules.emitter.settings.shapes.EmitterShape;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Plane
implements EmitterShape {
    @Override
    public Vector3d getPoint(RandomSource randomSource, Vector3fc dimensions, Vector3fc rotation, Vector3dc position, boolean fromSurface) {
        double x = randomSource.nextGaussian() * 2.0 - 1.0;
        double y = randomSource.nextGaussian() * 2.0 - 1.0;
        double z = randomSource.nextGaussian() * 2.0 - 1.0;
        double max = Math.max(Math.abs(x), Math.max(Math.abs(y), Math.abs(z)));
        Vector3d normal = new Vector3d(x / max, y / max, z / max).normalize();
        Vector3fc dim = dimensions;
        if (!fromSurface) {
            normal.mul(randomSource.nextDouble()).normalize();
            dim = dimensions.mul(randomSource.nextFloat(), randomSource.nextFloat(), randomSource.nextFloat(), new Vector3f());
        }
        Vector3d pos = normal.mul(dim);
        pos = pos.rotateX((double)((float)Math.toRadians(rotation.x()))).rotateY((double)((float)Math.toRadians(rotation.y()))).rotateZ((double)((float)Math.toRadians(rotation.z())));
        return pos.add(position);
    }

    @Override
    public void renderShape(PoseStack stack, VertexConsumer consumer, Vector3fc dimensions, Vector3fc rotation) {
        float x = dimensions.x();
        float y = 0.0f;
        float z = dimensions.z();
        LevelRenderer.renderLineBox((PoseStack)stack, (VertexConsumer)consumer, (AABB)new AABB((double)(-x), (double)(-y), (double)(-z), (double)x, (double)y, (double)z), (float)0.15f, (float)0.15f, (float)1.0f, (float)1.0f);
    }
}

