/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.quasar.data.QuasarParticles;
import foundry.veil.quasar.emitters.modules.emitter.settings.shapes.Cube;
import foundry.veil.quasar.emitters.modules.emitter.settings.shapes.Cylinder;
import foundry.veil.quasar.emitters.modules.emitter.settings.shapes.Disc;
import foundry.veil.quasar.emitters.modules.emitter.settings.shapes.EmitterShape;
import foundry.veil.quasar.emitters.modules.emitter.settings.shapes.Hemisphere;
import foundry.veil.quasar.emitters.modules.emitter.settings.shapes.Plane;
import foundry.veil.quasar.emitters.modules.emitter.settings.shapes.Point;
import foundry.veil.quasar.emitters.modules.emitter.settings.shapes.Sphere;
import foundry.veil.quasar.emitters.modules.emitter.settings.shapes.Torus;
import foundry.veil.quasar.util.CodecUtil;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public record EmitterShapeSettings(EmitterShape shape, Vector3fc dimensions, Vector3fc rotation, boolean fromSurface) {
    public static final BiMap<String, EmitterShape> SHAPES = HashBiMap.create(Map.of("point", new Point(), "hemisphere", new Hemisphere(), "cylinder", new Cylinder(), "sphere", new Sphere(), "cube", new Cube(), "torus", new Torus(), "disc", new Disc(), "plane", new Plane()));
    public static final Codec<EmitterShapeSettings> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("shape").xmap(s -> (EmitterShape)SHAPES.getOrDefault((Object)s.toLowerCase(), (Object)new Point()), s -> (String)SHAPES.inverse().get(s)).forGetter(EmitterShapeSettings::shape), (App)CodecUtil.VECTOR3F_CODEC.fieldOf("dimensions").forGetter(EmitterShapeSettings::dimensions), (App)CodecUtil.VECTOR3F_CODEC.fieldOf("rotation").forGetter(EmitterShapeSettings::rotation), (App)Codec.BOOL.fieldOf("from_surface").forGetter(EmitterShapeSettings::fromSurface)).apply((Applicative)instance, EmitterShapeSettings::new));
    public static final Codec<Holder<EmitterShapeSettings>> CODEC = RegistryFileCodec.create(QuasarParticles.EMITTER_SHAPE_SETTINGS, DIRECT_CODEC);

    public Vector3d getPos(RandomSource randomSource, Vector3dc pos) {
        return this.shape.getPoint(randomSource, this.dimensions, this.rotation, pos, this.fromSurface);
    }

    @Nullable
    public ResourceLocation getRegistryId() {
        return QuasarParticles.registryAccess().registryOrThrow(QuasarParticles.EMITTER_SHAPE_SETTINGS).getKey((Object)this);
    }
}

