/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.client.particle;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.Veil;
import foundry.veil.quasar.ParticleEmitter;
import foundry.veil.quasar.client.particle.QuasarParticle;
import foundry.veil.quasar.client.particle.RenderData;
import foundry.veil.quasar.client.particle.SpriteData;
import foundry.veil.quasar.data.ParticleSettings;
import foundry.veil.quasar.data.QuasarParticleData;
import foundry.veil.quasar.emitters.modules.particle.CollisionParticleModule;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Deprecated
public class QuasarVanillaParticle
extends Particle {
    public static final Vec3[] PLANE = new Vec3[]{new Vec3(-1.0, 1.0, 0.0), new Vec3(1.0, 1.0, 0.0), new Vec3(1.0, -1.0, 0.0), new Vec3(-1.0, -1.0, 0.0)};
    public static final Vec3[] CUBE = new Vec3[]{new Vec3(1.0, 1.0, -1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(-1.0, 1.0, 1.0), new Vec3(-1.0, 1.0, -1.0), new Vec3(-1.0, -1.0, -1.0), new Vec3(-1.0, -1.0, 1.0), new Vec3(1.0, -1.0, 1.0), new Vec3(1.0, -1.0, -1.0), new Vec3(-1.0, -1.0, 1.0), new Vec3(-1.0, 1.0, 1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(1.0, -1.0, 1.0), new Vec3(1.0, -1.0, -1.0), new Vec3(1.0, 1.0, -1.0), new Vec3(-1.0, 1.0, -1.0), new Vec3(-1.0, -1.0, -1.0), new Vec3(-1.0, -1.0, -1.0), new Vec3(-1.0, 1.0, -1.0), new Vec3(-1.0, 1.0, 1.0), new Vec3(-1.0, -1.0, 1.0), new Vec3(1.0, -1.0, 1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(1.0, 1.0, -1.0), new Vec3(1.0, -1.0, -1.0)};
    private static final ResourceLocation BLANK = Veil.veilPath("textures/special/blank.png");
    public boolean shouldCollide = false;
    protected boolean emissive = true;
    private boolean stoppedByCollision;
    private final QuasarParticle particle;
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.square((double)100.0);

    public QuasarVanillaParticle(QuasarParticleData data, ParticleSettings particleSettings, ParticleEmitter parentEmitter, ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.particle = null;
        float scale = this.particle.getRadius();
        float width = this.bbWidth / 2.0f;
        float height = this.bbHeight;
        this.setBoundingBox(new AABB(x - (double)width, y, z - (double)width, x + (double)width, y + (double)height, z + (double)width));
        this.setSize(scale * 0.5f, scale * 0.5f);
    }

    public void tick() {
        QuasarParticleData data;
        this.particle.tick();
        Vector3d velocity = this.particle.getVelocity();
        Vector3f rotation = this.particle.getRotation();
        if (this.stoppedByCollision || this.onGround) {
            for (CollisionParticleModule collisionParticle : this.particle.getModules().getCollisionModules()) {
                collisionParticle.collide(this.particle);
            }
        }
        if (!this.shouldCollide && this.particle.getModules().getCollisionModules().length > 0) {
            this.shouldCollide = true;
        }
        if ((data = this.particle.getData()).faceVelocity()) {
            Vector3d normalizedMotion = velocity.normalize(new Vector3d());
            rotation.x = (float)Math.atan2(normalizedMotion.y, Math.sqrt(normalizedMotion.x * normalizedMotion.x + normalizedMotion.z * normalizedMotion.z));
            rotation.y = (float)Math.atan2(normalizedMotion.x, normalizedMotion.z);
            if (data.renderStyle() == RenderStyle.BILLBOARD) {
                rotation.y += 1.5707964f;
            }
        }
        this.move(velocity.x, velocity.y, velocity.z);
        if (this.shouldCollide) {
            List entities = this.level.getEntities(null, this.getBoundingBox().inflate((double)(this.particle.getRadius() * 2.0f)));
            for (Entity entity : entities) {
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).isAlive()) continue;
                this.stoppedByCollision = true;
            }
        }
        if (this.particle.isRemoved()) {
            this.remove();
        }
    }

    public void remove() {
        this.particle.onRemove();
        super.remove();
    }

    public void move(double pX, double pY, double pZ) {
        if (!this.stoppedByCollision) {
            double d0 = pX;
            double d1 = pY;
            double d2 = pZ;
            if (this.shouldCollide && this.hasPhysics && (pX != 0.0 || pY != 0.0 || pZ != 0.0) && pX * pX + pY * pY + pZ * pZ < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
                Vec3 vec3 = Entity.collideBoundingBox(null, (Vec3)new Vec3(pX, pY, pZ), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
                pX = vec3.x;
                pY = vec3.y;
                pZ = vec3.z;
            }
            if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
                this.setBoundingBox(this.getBoundingBox().move(pX, pY, pZ));
                this.setLocationFromBoundingbox();
            }
            if (Math.abs(d1) >= (double)1.0E-5f && Math.abs(pY) < (double)1.0E-5f) {
                this.stoppedByCollision = this.shouldCollide;
            }
            boolean bl = this.onGround = d1 != pY && d1 < 0.0;
            if (d0 != pX) {
                this.particle.getVelocity().x = 0.0;
                this.stoppedByCollision = true;
            }
            if (d2 != pZ) {
                this.particle.getVelocity().z = 0.0;
                this.stoppedByCollision = true;
            }
        }
    }

    public void setPos(double x, double y, double z) {
        if (this.particle == null) {
            return;
        }
        this.particle.getPosition().set(x, y, z);
        float width = this.bbWidth / 2.0f;
        float height = this.bbHeight;
        this.setBoundingBox(new AABB(x - (double)width, y, z - (double)width, x + (double)width, y + (double)height, z + (double)width));
    }

    protected void setLocationFromBoundingbox() {
        AABB box = this.getBoundingBox();
        this.particle.getPosition().set((box.minX + box.maxX) / 2.0, box.minY, (box.minZ + box.maxZ) / 2.0);
    }

    protected int getLightColor(float $$0) {
        BlockPos pos = this.particle.getBlockPosition();
        return this.level.hasChunkAt(pos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)pos) : 0;
    }

    public void render(VertexConsumer builder, Camera camera, float partialTicks) {
        RenderData renderData = this.particle.getRenderData();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.getBuilder();
        builder = bufferBuilder;
        this.particle.render(partialTicks);
        Vec3 projectedView = camera.getPosition();
        Vector3dc renderPosition = renderData.getRenderPosition();
        Vector3f renderOffset = new Vector3f((float)(renderPosition.x() - projectedView.x()), (float)(renderPosition.y() - projectedView.y()), (float)(renderPosition.z() - projectedView.z()));
        Vector3d motionDirection = this.particle.getVelocity().normalize(new Vector3d());
        this.particle.getData().renderStyle().render(new PoseStack(), this.particle, renderData, (Vector3fc)renderOffset, (Vector3dc)motionDirection, builder, 1.0, partialTicks);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public Level getLevel() {
        return this.level;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum RenderStyle implements RenderFunction
    {
        CUBE{

            @Override
            public void render(PoseStack poseStack, QuasarParticle particle, RenderData renderData, Vector3fc renderOffset, Vector3dc motionDirection, VertexConsumer builder, double ageModifier, float partialTicks) {
                Matrix4f matrix4f = poseStack.last().pose();
                Vector3fc rotation = renderData.getRenderRotation();
                for (int i = 0; i < 6; ++i) {
                    Vec3[] faceVerts = new Vec3[]{QuasarVanillaParticle.CUBE[i * 4], QuasarVanillaParticle.CUBE[i * 4 + 1], QuasarVanillaParticle.CUBE[i * 4 + 2], QuasarVanillaParticle.CUBE[i * 4 + 3]};
                    TextureAtlasSprite sprite = renderData.getAtlasSprite();
                    if (sprite != null) {
                        builder = sprite.wrap(builder);
                    }
                    for (int j = 0; j < 4; ++j) {
                        Vector3f vec = faceVerts[j].toVector3f().mul(-1.0f);
                        QuasarParticleData data = particle.getData();
                        if (vec.z < 0.0f && data.velocityStretchFactor() != 0.0f) {
                            vec.z *= 1.0f + data.velocityStretchFactor();
                        }
                        vec.rotateX(rotation.x()).rotateY(rotation.y()).rotateZ(rotation.z()).mul((float)((double)renderData.getRenderRadius() * ageModifier)).add(renderOffset);
                        builder.vertex(matrix4f, vec.x, vec.y, vec.z);
                        builder.uv((float)j / 2.0f, (float)(j % 2));
                        builder.color(renderData.getRed(), renderData.getGreen(), renderData.getBlue(), renderData.getAlpha());
                        builder.uv2(renderData.getLightColor());
                        builder.endVertex();
                    }
                }
            }
        }
        ,
        BILLBOARD{

            @Override
            public void render(PoseStack poseStack, QuasarParticle particle, RenderData renderData, Vector3fc renderOffset, Vector3dc motionDirection, VertexConsumer builder, double ageModifier, float partialTicks) {
                Matrix4f matrix4f = poseStack.last().pose();
                Vector3fc rotation = renderData.getRenderRotation();
                Vec3[] faceVerts = new Vec3[]{PLANE[0], PLANE[1], PLANE[2], PLANE[3]};
                Quaternionf faceCameraRotation = Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation();
                SpriteData spriteData = renderData.getSpriteData();
                TextureAtlasSprite sprite = renderData.getAtlasSprite();
                if (sprite != null) {
                    builder = sprite.wrap(builder);
                }
                for (int j = 0; j < 4; ++j) {
                    float v;
                    float u;
                    Vector3f vec = faceVerts[j].toVector3f().mul(-1.0f);
                    if (particle.getData().velocityStretchFactor() > 0.0f) {
                        vec.set(vec.x * (1.0f + particle.getData().velocityStretchFactor()), vec.y, vec.z);
                    }
                    if (particle.getData().faceVelocity()) {
                        vec.rotateX(rotation.x()).rotateY(rotation.y()).rotateZ(rotation.z());
                    }
                    faceCameraRotation.transform(vec).mul((float)((double)renderData.getRenderRadius() * ageModifier)).add(renderOffset);
                    if (j == 0) {
                        u = 0.0f;
                        v = 0.0f;
                    } else if (j == 1) {
                        u = 1.0f;
                        v = 0.0f;
                    } else if (j == 2) {
                        u = 1.0f;
                        v = 1.0f;
                    } else {
                        u = 0.0f;
                        v = 1.0f;
                    }
                    if (spriteData != null) {
                        int spritesheetRows = spriteData.frameHeight();
                        int spritesheetColumns = spriteData.frameWidth();
                        int spriteCount = spriteData.frameCount();
                        float animationSpeed = spriteData.frameTime();
                        int frameIndex = (int)(renderData.getRenderAge() / animationSpeed);
                        int frameIndexInSpritesheet = frameIndex % spriteCount;
                        int frameRow = frameIndexInSpritesheet / spritesheetColumns;
                        int frameColumn = frameIndexInSpritesheet % spritesheetColumns;
                        u *= 1.0f / (float)spritesheetColumns + (float)frameColumn * (1.0f / (float)spritesheetColumns);
                        v *= 1.0f / (float)spritesheetRows + (float)frameRow * (1.0f / (float)spritesheetRows);
                    }
                    builder.vertex(matrix4f, vec.x, vec.y, vec.z);
                    builder.uv(u, v);
                    builder.color(renderData.getRed(), renderData.getGreen(), renderData.getBlue(), renderData.getAlpha());
                    builder.uv2(renderData.getLightColor());
                    builder.endVertex();
                }
            }
        };

    }

    @FunctionalInterface
    static interface RenderFunction {
        public void render(PoseStack var1, QuasarParticle var2, RenderData var3, Vector3fc var4, Vector3dc var5, VertexConsumer var6, double var7, float var9);
    }
}

