/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar.client.particle;

import com.google.common.base.Suppliers;
import com.mojang.logging.LogUtils;
import foundry.veil.quasar.ParticleEmitter;
import foundry.veil.quasar.client.particle.ParticleModuleSet;
import foundry.veil.quasar.client.particle.QuasarVanillaParticle;
import foundry.veil.quasar.client.particle.RenderData;
import foundry.veil.quasar.data.ParticleSettings;
import foundry.veil.quasar.data.QuasarParticleData;
import foundry.veil.quasar.data.module.ParticleModuleData;
import foundry.veil.quasar.emitters.modules.particle.CollisionParticleModule;
import foundry.veil.quasar.emitters.modules.particle.InitParticleModule;
import foundry.veil.quasar.emitters.modules.particle.ParticleModule;
import foundry.veil.quasar.emitters.modules.particle.RenderParticleModule;
import foundry.veil.quasar.emitters.modules.particle.UpdateParticleModule;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class QuasarParticle {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.square((double)100.0);
    private static final Set<Holder<ParticleModuleData>> REPORTED_MODULES = new HashSet<Holder<ParticleModuleData>>();
    private final ClientLevel level;
    private final RandomSource randomSource;
    private final QuasarParticleData data;
    private final ParticleSettings settings;
    private final ParticleEmitter parent;
    private final ParticleModuleSet modules;
    private final Vector3d position;
    private final Vector3d velocity;
    private final Vector3f rotation;
    private final BlockPos.MutableBlockPos blockPosition;
    private final boolean hasCollision;
    private float radius;
    private final int lifetime;
    private int age;
    private AABB boundingBox;
    private boolean stoppedByCollision;
    private final Supplier<MolangRuntime> environment;
    private final RenderData renderData;

    public QuasarParticle(ClientLevel level, RandomSource randomSource, QuasarParticleData data, ParticleSettings settings, ParticleEmitter parent) {
        this.level = level;
        this.randomSource = randomSource;
        this.data = data;
        this.settings = settings;
        this.parent = parent;
        this.modules = QuasarParticle.createModuleSet(data);
        this.position = new Vector3d();
        this.velocity = new Vector3d();
        this.rotation = new Vector3f();
        this.blockPosition = new BlockPos.MutableBlockPos();
        this.hasCollision = this.modules.getCollisionModules().length > 0;
        this.radius = settings.particleSize(this.randomSource);
        this.lifetime = settings.particleLifetime(this.randomSource);
        this.age = 0;
        this.renderData = new RenderData();
        this.environment = Suppliers.memoize(() -> (MolangRuntime)MolangRuntime.runtime().setQuery("x", MolangExpression.of(() -> Float.valueOf((float)this.renderData.getRenderPosition().x()))).setQuery("y", MolangExpression.of(() -> Float.valueOf((float)this.renderData.getRenderPosition().y()))).setQuery("z", MolangExpression.of(() -> Float.valueOf((float)this.renderData.getRenderPosition().z()))).setQuery("velX", MolangExpression.of(() -> Float.valueOf((float)this.velocity.x()))).setQuery("velY", MolangExpression.of(() -> Float.valueOf((float)this.velocity.y()))).setQuery("velZ", MolangExpression.of(() -> Float.valueOf((float)this.velocity.z()))).setQuery("speedSq", MolangExpression.of(() -> Float.valueOf((float)this.velocity.lengthSquared()))).setQuery("speed", MolangExpression.of(() -> Float.valueOf((float)this.velocity.length()))).setQuery("xRot", MolangExpression.of(() -> Float.valueOf((float)Math.toDegrees(this.renderData.getRenderRotation().x())))).setQuery("yRot", MolangExpression.of(() -> Float.valueOf((float)Math.toDegrees(this.renderData.getRenderRotation().y())))).setQuery("zRot", MolangExpression.of(() -> Float.valueOf((float)Math.toDegrees(this.renderData.getRenderRotation().z())))).setQuery("scale", MolangExpression.of(this.renderData::getRenderRadius)).setQuery("age", MolangExpression.of(this.renderData::getRenderAge)).setQuery("agePercent", MolangExpression.of(this.renderData::getAgePercent)).setQuery("lifetime", this.lifetime).create());
    }

    private static ParticleModuleSet createModuleSet(QuasarParticleData data) {
        ParticleModuleSet.Builder builder = ParticleModuleSet.builder();
        data.allModules().forEach(module -> {
            if (!module.isBound()) {
                if (REPORTED_MODULES.add((Holder<ParticleModuleData>)module)) {
                    String string;
                    if (module instanceof Holder.Reference) {
                        Holder.Reference ref = (Holder.Reference)module;
                        string = ref.key().location();
                    } else {
                        string = module.getClass().getName();
                    }
                    LOGGER.error("Unknown module: {}", (Object)string);
                }
                return;
            }
            ((ParticleModuleData)module.value()).addModules(builder);
        });
        return builder.build();
    }

    private void move(double dx, double dy, double dz) {
        if (this.stoppedByCollision || dx == 0.0 && dy == 0.0 && dz == 0.0) {
            return;
        }
        AABB box = this.getBoundingBox();
        double d0 = dx;
        double d1 = dy;
        double d2 = dz;
        if (this.hasCollision && dx * dx + dy * dy + dz * dz < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            Vec3 vec3 = Entity.collideBoundingBox(null, (Vec3)new Vec3(dx, dy, dz), (AABB)box, (Level)this.level, List.of());
            dx = vec3.x;
            dy = vec3.y;
            dz = vec3.z;
        }
        if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
            this.position.add(dx, dy, dz);
            this.updateBoundingBox();
        }
        if (!this.hasCollision) {
            return;
        }
        List entities = this.level.getEntities(null, box);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).isAlive()) continue;
            this.stoppedByCollision = true;
            break;
        }
        if (Math.abs(d1) >= (double)1.0E-5f && Math.abs(dy) < (double)1.0E-5f) {
            this.stoppedByCollision = true;
        }
        if (d0 != dx) {
            this.velocity.x = 0.0;
            this.stoppedByCollision = true;
        }
        if (d1 != dy) {
            this.velocity.y = 0.0;
            this.stoppedByCollision = true;
        }
        if (d2 != dz) {
            this.velocity.z = 0.0;
            this.stoppedByCollision = true;
        }
        if (this.stoppedByCollision) {
            for (CollisionParticleModule collisionParticle : this.modules.getCollisionModules()) {
                collisionParticle.collide(this);
            }
        }
    }

    private void updateBoundingBox() {
        double r = (double)this.radius / 2.0;
        this.boundingBox = new AABB(this.position.x - r, this.position.y - r, this.position.z - r, this.position.x + r, this.position.y + r, this.position.z + r);
    }

    private int getLightColor() {
        BlockPos pos = this.getBlockPosition();
        return this.level.hasChunkAt(pos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)pos) : 0;
    }

    @ApiStatus.Internal
    public void init() {
        for (InitParticleModule initModule : this.modules.getInitModules()) {
            initModule.init(this);
        }
        this.renderData.tick(this, this.getLightColor());
        this.updateBoundingBox();
    }

    @ApiStatus.Internal
    public static void clearErrors() {
        REPORTED_MODULES.clear();
    }

    @ApiStatus.Internal
    public void tick() {
        this.renderData.tick(this, this.getLightColor());
        for (UpdateParticleModule updateParticleModule : this.modules.getUpdateModules()) {
            updateParticleModule.update(this);
        }
        for (ParticleModule particleModule : this.modules.getForceModules()) {
            particleModule.applyForce(this);
        }
        if (this.data.faceVelocity()) {
            Vector3d normalizedMotion = this.velocity.normalize(new Vector3d());
            this.rotation.x = (float)Mth.atan2((double)normalizedMotion.y, (double)Math.sqrt(normalizedMotion.x * normalizedMotion.x + normalizedMotion.z * normalizedMotion.z));
            this.rotation.y = (float)Mth.atan2((double)normalizedMotion.x, (double)normalizedMotion.z);
            if (this.data.renderStyle() == QuasarVanillaParticle.RenderStyle.BILLBOARD) {
                this.rotation.y += 1.5707964f;
            }
        }
        this.move(this.velocity.x, this.velocity.y, this.velocity.z);
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
        }
    }

    @ApiStatus.Internal
    public void render(float partialTicks) {
        for (RenderParticleModule renderModule : this.modules.getRenderModules()) {
            renderModule.render(this, partialTicks);
        }
        this.renderData.render(this, partialTicks);
    }

    @ApiStatus.Internal
    public void onRemove() {
        for (ParticleModule module : this.modules.getAllModules()) {
            module.onRemove();
        }
    }

    public void remove() {
        this.age = Integer.MIN_VALUE;
    }

    public boolean isRemoved() {
        return this.age < 0;
    }

    public ClientLevel getLevel() {
        return this.level;
    }

    public RandomSource getRandomSource() {
        return this.randomSource;
    }

    public QuasarParticleData getData() {
        return this.data;
    }

    public ParticleSettings getSettings() {
        return this.settings;
    }

    public ParticleEmitter getParent() {
        return this.parent;
    }

    public ParticleModuleSet getModules() {
        return this.modules;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public BlockPos getBlockPosition() {
        return this.blockPosition.set(this.position.x, this.position.y, this.position.z);
    }

    public Vector3d getVelocity() {
        return this.velocity;
    }

    public BlockState getBlockStateInOrUnder() {
        BlockState in = this.level.getBlockState(BlockPos.containing((double)this.position.x, (double)(this.position.y + 0.5), (double)this.position.z));
        if (!in.isAir()) {
            return in;
        }
        return this.level.getBlockState(BlockPos.containing((double)this.position.x, (double)(this.position.y - 0.5), (double)this.position.z));
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getAge() {
        return this.age;
    }

    public int getLifetime() {
        return this.settings.particleLifetime();
    }

    public AABB getBoundingBox() {
        return this.boundingBox;
    }

    public RenderData getRenderData() {
        return this.renderData;
    }

    public MolangEnvironment getEnvironment() {
        return this.environment.get();
    }

    public void vectorToRotation(double x, double y, double z) {
        this.rotation.set((float)Math.asin(y), (float)Math.atan2(x, z), 0.0f);
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.updateBoundingBox();
    }

    public void setAge(int age) {
        this.age = age;
    }
}

