/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.quasar;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.api.client.render.VeilRenderType;
import foundry.veil.quasar.ParticleSystemManager;
import foundry.veil.quasar.client.particle.QuasarParticle;
import foundry.veil.quasar.client.particle.QuasarVanillaParticle;
import foundry.veil.quasar.client.particle.RenderData;
import foundry.veil.quasar.data.EmitterSettings;
import foundry.veil.quasar.data.ParticleEmitterData;
import foundry.veil.quasar.data.QuasarParticleData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleEmitter {
    private final ParticleSystemManager particleManager;
    private final ClientLevel level;
    private final ParticleEmitterData emitterData;
    private final RandomSource randomSource;
    private final Vector3d position;
    private final List<QuasarParticle> particles;
    @Nullable
    private Entity attachedEntity;
    private boolean removed;
    private int age;

    ParticleEmitter(ParticleSystemManager particleManager, ClientLevel level, ParticleEmitterData data) {
        this.particleManager = particleManager;
        this.level = level;
        this.emitterData = data;
        this.randomSource = RandomSource.create();
        this.position = new Vector3d();
        this.particles = new ArrayList<QuasarParticle>(data.maxParticles());
    }

    private void run() {
        EmitterSettings emitterSettings = this.emitterData.emitterSettings();
        Vector3d particlePos = emitterSettings.emitterShapeSettings().getPos(this.randomSource, (Vector3dc)this.position);
        Vector3f particleDirection = emitterSettings.particleSettings().particleDirection(this.randomSource);
        QuasarParticle particle = new QuasarParticle(this.level, this.randomSource, this.emitterData.particleData(), this.emitterData.emitterSettings().particleSettings(), this);
        particle.getPosition().set((Vector3dc)particlePos);
        particle.getVelocity().set((Vector3fc)particleDirection);
        particle.init();
        this.particles.add(particle);
    }

    public void tick() {
        if (this.attachedEntity != null) {
            if (this.attachedEntity.isAlive()) {
                Vec3 pos = this.attachedEntity.position();
                this.position.set(pos.x, pos.y, pos.z);
            } else {
                this.attachedEntity = null;
            }
        }
        Iterator<QuasarParticle> iterator = this.particles.iterator();
        while (iterator.hasNext()) {
            QuasarParticle particle = iterator.next();
            particle.tick();
            if (!particle.isRemoved()) continue;
            iterator.remove();
            particle.onRemove();
        }
        if (!this.removed) {
            if (this.age % this.emitterData.rate() == 0) {
                int count = Math.min(this.emitterData.maxParticles(), (int)Math.ceil((float)this.emitterData.count() * this.particleManager.getSpawnScale()));
                for (int i = 0; i < count; ++i) {
                    this.run();
                }
            }
            if (this.age > this.emitterData.maxLifetime()) {
                if (this.emitterData.loop()) {
                    this.age = 0;
                } else {
                    this.remove();
                }
            }
        }
        ++this.age;
    }

    @ApiStatus.Internal
    public void render(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, float partialTicks) {
        Vec3 projectedView = camera.getPosition();
        QuasarParticleData particleData = this.emitterData.particleData();
        QuasarVanillaParticle.RenderStyle renderStyle = particleData.renderStyle();
        Vector3f renderOffset = new Vector3f();
        Vector3d motionDirection = new Vector3d();
        for (QuasarParticle particle : this.particles) {
            RenderData renderData = particle.getRenderData();
            particle.render(partialTicks);
            renderData.renderTrails(poseStack, bufferSource, projectedView, 0xF000F0);
            Vector3dc renderPosition = renderData.getRenderPosition();
            renderOffset.set((float)(renderPosition.x() - projectedView.x()), (float)(renderPosition.y() - projectedView.y()), (float)(renderPosition.z() - projectedView.z()));
            particle.getVelocity().normalize(motionDirection);
            VertexConsumer builder = bufferSource.getBuffer(VeilRenderType.quasarParticle(renderData.getTexture()));
            renderStyle.render(poseStack, particle, renderData, (Vector3fc)renderOffset, (Vector3dc)motionDirection, builder, 1.0, partialTicks);
        }
    }

    @ApiStatus.Internal
    void onRemoved() {
        for (QuasarParticle particle : this.particles) {
            particle.onRemove();
        }
        this.particles.clear();
    }

    public void remove() {
        this.removed = true;
    }

    public void reset() {
        this.age = 0;
        this.removed = false;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.emitterData.getRegistryId();
    }

    public boolean isRemoved() {
        return this.removed && this.particles.isEmpty();
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public ParticleEmitterData getData() {
        return this.emitterData;
    }

    public int getParticleCount() {
        return this.particles.size();
    }

    @Nullable
    public Entity getAttachedEntity() {
        return this.attachedEntity;
    }

    @Deprecated
    public void setPosition(Vec3 position) {
        this.position.set(position.x, position.y, position.z);
    }

    public void setPosition(Vector3dc position) {
        this.position.set(position);
    }

    public void setAttachedEntity(@Nullable Entity entity) {
        this.attachedEntity = entity;
    }
}

