/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.debug;

import foundry.veil.Veil;
import foundry.veil.platform.services.VeilPlatform;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.main.Main;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Main.class})
public class RenderDocker {
    @Unique
    private static final int ENABLE_TIME = 4000;

    @Inject(method={"main"}, at={@At(value="HEAD")}, remap=false)
    private static void preMain(String[] pArgs, CallbackInfo ci) {
        VeilPlatform platform = Veil.platform();
        if (!platform.isDevelopmentEnvironment() || platform.isModLoaded("tracky")) {
            return;
        }
        String path = System.getProperty("java.library.path");
        String name = System.mapLibraryName("renderdoc");
        boolean detected = false;
        for (String folder : path.split(";")) {
            if (!Files.exists(Path.of(folder + "/" + name, new String[0]), new LinkOption[0])) continue;
            detected = true;
            break;
        }
        if (!detected) {
            return;
        }
        AtomicBoolean enable = new AtomicBoolean();
        Thread td = new Thread(() -> {
            Veil.LOGGER.warn("Renderdoc detected, would you like to load it? y/N");
            long start = System.currentTimeMillis();
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while (System.currentTimeMillis() - start <= 4000L) {
                try {
                    if (!reader.ready()) continue;
                    String ln = reader.readLine().trim().toLowerCase(Locale.ROOT);
                    if (ln.startsWith("y")) {
                        enable.set(true);
                        return;
                    }
                    if (!ln.startsWith("n")) continue;
                    return;
                }
                catch (Exception exception) {
                }
            }
        }, "Veil-RenderDocker");
        td.setDaemon(true);
        td.start();
        try {
            td.join();
            if (enable.get()) {
                System.loadLibrary("renderdoc");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

