/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.modifier;

import foundry.veil.impl.client.render.shader.modifier.ShaderModification;
import java.io.IOException;
import java.util.regex.Matcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SimpleShaderModification
implements ShaderModification {
    private final int version;
    private final int priority;
    private final ResourceLocation[] includes;
    private final String output;
    private final String uniform;
    private final ShaderModification.Function[] functions;

    public SimpleShaderModification(int version, int priority, ResourceLocation[] includes, @Nullable String output, @Nullable String uniform, ShaderModification.Function[] functions) {
        this.version = version;
        this.priority = priority;
        this.includes = includes;
        this.output = output;
        this.uniform = uniform;
        this.functions = functions;
    }

    @Override
    public String inject(String source, int flags) throws IOException {
        int pointer;
        if ((flags & 1) > 0) {
            Matcher versionMatcher = VERSION_PATTERN.matcher(source);
            if (!versionMatcher.find()) {
                throw new IOException("Failed to find version");
            }
            if (this.version == -1) {
                throw new IOException("Missing #version field");
            }
            try {
                int version = Integer.parseInt(versionMatcher.group(1));
                if (version < this.version) {
                    source = versionMatcher.replaceAll("#version " + this.version + "\n\n");
                    versionMatcher.reset(source);
                    if (!versionMatcher.find()) {
                        throw new IllegalStateException();
                    }
                }
            }
            catch (Exception e) {
                throw new IOException("Failed to inject version", e);
            }
            pointer = versionMatcher.end();
        } else {
            pointer = 0;
        }
        StringBuilder result = new StringBuilder(source);
        for (ResourceLocation include : this.includes) {
            String code = "#include " + include + "\n";
            result.insert(pointer, code);
            pointer += code.length();
        }
        this.processBody(pointer, result);
        return result.toString();
    }

    protected void processBody(int pointer, StringBuilder builder) throws IOException {
        String code;
        Matcher matcher;
        if (!StringUtil.isNullOrEmpty((String)this.uniform)) {
            matcher = UNIFORM_PATTERN.matcher(builder);
            while (matcher.find()) {
                pointer = matcher.end();
            }
            code = this.fillPlaceholders(this.uniform) + "\n";
            builder.insert(pointer, code);
            pointer += code.length();
        }
        if (!StringUtil.isNullOrEmpty((String)this.output)) {
            matcher = OUT_PATTERN.matcher(builder);
            while (matcher.find()) {
                pointer = matcher.end();
            }
            code = this.fillPlaceholders(this.output) + "\n";
            builder.insert(pointer, code);
        }
        for (ShaderModification.Function function : this.functions) {
            Matcher matcher2 = function.pattern().matcher(builder);
            if (!matcher2.find()) {
                throw new IOException("Unknown function: " + function.name());
            }
            if (!function.head()) {
                int head;
                int parenthesis = 1;
                for (pointer = head = matcher2.end(); pointer < builder.length(); ++pointer) {
                    if (builder.charAt(pointer) == '{') {
                        ++parenthesis;
                    }
                    if (builder.charAt(pointer) == '}') {
                        --parenthesis;
                    }
                    if (parenthesis != 0) continue;
                    --pointer;
                    break;
                }
                Matcher returnMatcher = RETURN_PATTERN.matcher(builder.substring(head, pointer));
                while (returnMatcher.find()) {
                    pointer = returnMatcher.start() - 1;
                }
            }
            String code2 = this.fillPlaceholders("\n{\n" + function.code() + "}");
            builder.insert(pointer, code2);
            if (!matcher2.find()) continue;
            throw new IOException("Ambiguous method: " + function.name());
        }
    }

    public String fillPlaceholders(String code) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(code);
        if (!matcher.find()) {
            return code;
        }
        StringBuilder sb = new StringBuilder();
        matcher.appendReplacement(sb, this.getPlaceholder(matcher.group(1)));
        while (matcher.find()) {
            matcher.appendReplacement(sb, this.getPlaceholder(matcher.group(1)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected String getPlaceholder(String key) {
        return key;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public String getOutput() {
        return this.output;
    }
}

