/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.shader.CompiledShader;
import foundry.veil.api.client.render.shader.ShaderCompiler;
import foundry.veil.api.client.render.shader.ShaderException;
import foundry.veil.api.client.render.shader.program.MutableShaderUniformAccess;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL31C;

@ApiStatus.Internal
public class ShaderProgramImpl
implements ShaderProgram {
    private final ResourceLocation id;
    private final Set<CompiledShader> shaders;
    private final Map<CharSequence, Integer> uniforms;
    private final Map<CharSequence, Integer> blocks;
    private final Map<CharSequence, Integer> textures;
    private final Map<String, ShaderTextureSource> textureSources;
    private final Set<String> definitionDependencies;
    private final Supplier<Wrapper> wrapper;
    private int program;

    public ShaderProgramImpl(ResourceLocation id) {
        this.id = id;
        this.shaders = new HashSet<CompiledShader>(2);
        this.uniforms = new Object2IntArrayMap();
        this.blocks = new Object2IntArrayMap();
        this.textures = new HashMap<CharSequence, Integer>();
        this.textureSources = new HashMap<String, ShaderTextureSource>();
        this.definitionDependencies = new HashSet<String>();
        this.wrapper = Suppliers.memoize(() -> {
            Wrapper.constructing = true;
            try {
                Wrapper wrapper = new Wrapper(this);
                return wrapper;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to wrap shader program: " + this.getId(), e);
            }
            finally {
                Wrapper.constructing = false;
            }
        });
    }

    private void clearShader() {
        if (this.program != 0) {
            this.shaders.forEach(shader -> GL20C.glDetachShader((int)this.program, (int)shader.id()));
        }
        this.shaders.clear();
        this.uniforms.clear();
        this.blocks.clear();
        this.textures.clear();
        this.textureSources.clear();
        this.definitionDependencies.clear();
    }

    @Override
    public void compile(ShaderCompiler.Context context, ShaderCompiler compiler) throws Exception {
        ProgramDefinition definition = Objects.requireNonNull(context.definition());
        this.clearShader();
        this.textureSources.putAll(definition.textures());
        if (this.program == 0) {
            this.program = GL20C.glCreateProgram();
        }
        try {
            Map<Integer, ResourceLocation> shaders = definition.shaders();
            for (Map.Entry<Integer, ResourceLocation> entry : shaders.entrySet()) {
                CompiledShader shader2 = compiler.compile(context, (int)entry.getKey(), entry.getValue());
                GL20C.glAttachShader((int)this.program, (int)shader2.id());
                this.shaders.add(shader2);
            }
            if (Minecraft.ON_OSX && !shaders.containsKey(37305) && !shaders.containsKey(35632)) {
                CompiledShader shader3 = compiler.compile(context, 35632, "out vec4 fragColor;void main(){fragColor=vec4(1.0);}");
                GL20C.glAttachShader((int)this.program, (int)shader3.id());
                this.shaders.add(shader3);
            }
            GL20C.glLinkProgram((int)this.program);
            if (GL20C.glGetProgrami((int)this.program, (int)35714) != 1) {
                String log = GL20C.glGetProgramInfoLog((int)this.program);
                throw new ShaderException("Failed to link shader", log);
            }
            this.bind();
            this.shaders.forEach(shader -> {
                shader.apply(this);
                this.definitionDependencies.addAll(shader.definitionDependencies());
            });
            ShaderProgram.unbind();
        }
        catch (Exception e) {
            this.free();
            throw e;
        }
    }

    public void free() {
        this.clearShader();
        if (this.program > 0) {
            GL20C.glDeleteProgram((int)this.program);
            this.program = 0;
        }
    }

    @Override
    public Set<CompiledShader> getShaders() {
        return this.shaders;
    }

    @Override
    public Set<String> getDefinitionDependencies() {
        return this.definitionDependencies;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public Wrapper toShaderInstance() {
        return this.wrapper.get();
    }

    @Override
    public int getUniform(CharSequence name) {
        if (this.program == 0) {
            return -1;
        }
        return this.uniforms.computeIfAbsent(name, k -> GL20C.glGetUniformLocation((int)this.program, (CharSequence)k));
    }

    @Override
    public int getUniformBlock(CharSequence name) {
        if (this.program == 0) {
            return -1;
        }
        return this.blocks.computeIfAbsent(name, k -> GL31C.glGetUniformBlockIndex((int)this.program, (CharSequence)name));
    }

    @Override
    public int getProgram() {
        return this.program;
    }

    @Override
    public int applyShaderSamplers(@Nullable ShaderTextureSource.Context context, int sampler) {
        if (context != null) {
            this.textureSources.forEach((name, source) -> this.addSampler((CharSequence)name, source.getId(context)));
        }
        int activeTexture = GlStateManager._getActiveTexture();
        RenderSystem.activeTexture((int)33984);
        RenderSystem.bindTexture((int)MissingTextureAtlasSprite.getTexture().getId());
        ++sampler;
        for (Map.Entry<CharSequence, Integer> entry : this.textures.entrySet()) {
            if (this.getUniform(entry.getKey()) == -1) continue;
            RenderSystem.activeTexture((int)(33984 + sampler));
            RenderSystem.bindTexture((int)entry.getValue());
            this.setInt(entry.getKey(), sampler);
            ++sampler;
        }
        RenderSystem.activeTexture((int)activeTexture);
        return sampler;
    }

    @Override
    public void addSampler(CharSequence name, int textureId) {
        this.textures.put(name, textureId);
    }

    @Override
    public void removeSampler(CharSequence name) {
        this.textures.remove(name);
    }

    @Override
    public void clearSamplers() {
        this.textures.clear();
    }

    public static class Wrapper
    extends ShaderInstance {
        private static final byte[] DUMMY_SHADER = "{\n    \"vertex\": \"dummy\",\n    \"fragment\": \"dummy\"\n}\n".getBytes(StandardCharsets.UTF_8);
        private static final Resource RESOURCE = new Resource(null, () -> new ByteArrayInputStream(DUMMY_SHADER)){

            public PackResources source() {
                throw new UnsupportedOperationException("No pack source");
            }

            public String sourcePackId() {
                return "dummy";
            }

            public boolean isBuiltin() {
                return true;
            }
        };
        public static boolean constructing = false;
        private final ShaderProgram program;

        private Wrapper(ShaderProgram program) throws IOException {
            super(name -> Optional.of(RESOURCE), "", null);
            this.program = program;
        }

        public void close() {
        }

        public void clear() {
            ShaderProgram.unbind();
        }

        public void apply() {
            this.program.setup();
        }

        public void attachToProgram() {
            throw new UnsupportedOperationException("Cannot attach shader program wrapper");
        }

        public void markDirty() {
        }

        @Nullable
        public UniformWrapper getUniform(String name) {
            UniformWrapper uniform = (UniformWrapper)((Object)this.uniformMap.get(name));
            if (uniform != null) {
                return uniform.getLocation() == -1 ? null : uniform;
            }
            if (this.program != null && this.program.getUniform(name) == -1) {
                return null;
            }
            return (UniformWrapper)this.uniformMap.computeIfAbsent(name, unused -> new UniformWrapper(() -> this.program, name));
        }

        public void setSampler(String name, Object value) {
            int sampler = -1;
            if (value instanceof RenderTarget) {
                RenderTarget target = (RenderTarget)value;
                sampler = target.getColorTextureId();
            } else if (value instanceof AbstractTexture) {
                AbstractTexture texture = (AbstractTexture)value;
                sampler = texture.getId();
            } else if (value instanceof Integer) {
                Integer id = (Integer)value;
                sampler = id;
            }
            if (sampler != -1) {
                this.program.addSampler(name, sampler);
            }
        }

        public ShaderProgram program() {
            return this.program;
        }
    }

    public static class UniformWrapper
    extends Uniform {
        private final Supplier<MutableShaderUniformAccess> access;

        public UniformWrapper(Supplier<MutableShaderUniformAccess> access, String name) {
            super(name, 0, 0, null);
            this.close();
            this.access = access;
        }

        public void setLocation(int location) {
        }

        public void set(int index, float value) {
            throw new UnsupportedOperationException("Use absolute set");
        }

        public void set(float value) {
            this.access.get().setFloat(this.getName(), value);
        }

        public void set(float x, float y) {
            this.access.get().setVector(this.getName(), x, y);
        }

        public void set(float x, float y, float z) {
            this.access.get().setVector(this.getName(), x, y, z);
        }

        public void set(float x, float y, float z, float w) {
            this.access.get().setVector(this.getName(), x, y, z, w);
        }

        public void set(@NotNull Vector3f value) {
            this.access.get().setVector((CharSequence)this.getName(), (Vector3fc)value);
        }

        public void set(@NotNull Vector4f value) {
            this.access.get().setVector((CharSequence)this.getName(), (Vector4fc)value);
        }

        public void setSafe(float x, float y, float z, float w) {
            this.set(x, y, z, w);
        }

        public void set(int value) {
            this.access.get().setInt(this.getName(), value);
        }

        public void set(int x, int y) {
            this.access.get().setVector(this.getName(), x, y);
        }

        public void set(int x, int y, int z) {
            this.access.get().setVector(this.getName(), x, y, z);
        }

        public void set(int x, int y, int z, int w) {
            this.access.get().setVector(this.getName(), x, y, z, w);
        }

        public void setSafe(int x, int y, int z, int w) {
            this.set(x, y, z, w);
        }

        public void set(float[] values) {
            switch (values.length) {
                case 1: {
                    this.set(values[0]);
                    break;
                }
                case 2: {
                    this.set(values[0], values[1]);
                    break;
                }
                case 3: {
                    this.set(values[0], values[1], values[2]);
                    break;
                }
                case 4: {
                    this.set(values[0], values[1], values[2], values[3]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid value array: " + Arrays.toString(values));
                }
            }
        }

        public void setMat2x2(float $$0, float $$1, float $$2, float $$3) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void setMat2x3(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void setMat2x4(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void setMat3x2(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void setMat3x3(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void setMat3x4(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void setMat4x2(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void setMat4x3(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void setMat4x4(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11, float $$12, float $$13, float $$14, float $$15) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void set(@NotNull Matrix3f value) {
            this.access.get().setMatrix((CharSequence)this.getName(), (Matrix3fc)value);
        }

        public void set(@NotNull Matrix4f value) {
            this.access.get().setMatrix((CharSequence)this.getName(), (Matrix4fc)value);
        }

        public void upload() {
        }

        public int getLocation() {
            return this.access.get().getUniform(this.getName());
        }
    }
}

