/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.pipeline;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.definition.ShaderBlock;
import foundry.veil.impl.client.render.shader.definition.ShaderBlockImpl;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VeilUniformBlockState {
    private final Map<ShaderBlockImpl<?>, Integer> boundBlocks = new HashMap();
    private final Map<Integer, CharSequence> shaderBindings = new HashMap<Integer, CharSequence>();
    private final IntSet usedBindings = new IntOpenHashSet();
    private int nextBinding;

    private void freeBinding() {
        Iterator<Map.Entry<ShaderBlockImpl<?>, Integer>> iterator = this.boundBlocks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ShaderBlockImpl<?>, Integer> entry = iterator.next();
            int binding = entry.getValue();
            if (this.usedBindings.contains(binding)) continue;
            this.unbind(binding, entry.getKey());
            iterator.remove();
            this.nextBinding = binding;
            return;
        }
        throw new IllegalStateException("Too many shader blocks bound, failed to find empty space.");
    }

    public int bind(ShaderBlock<?> block) {
        if (!(block instanceof ShaderBlockImpl)) {
            throw new UnsupportedOperationException("Cannot bind " + block.getClass());
        }
        ShaderBlockImpl impl = (ShaderBlockImpl)block;
        int binding = this.boundBlocks.getOrDefault(block, -1);
        if (binding == -1) {
            if (this.nextBinding >= VeilRenderSystem.maxUniformBuffersBindings()) {
                this.freeBinding();
            }
            binding = this.nextBinding;
            this.boundBlocks.put(impl, binding);
            while (this.boundBlocks.containsValue(this.nextBinding)) {
                ++this.nextBinding;
            }
        }
        impl.bind(binding);
        this.usedBindings.add(binding);
        return binding;
    }

    public void bind(CharSequence name, ShaderBlock<?> block) {
        int binding = this.bind(block);
        CharSequence boundName = this.shaderBindings.get(binding);
        if (!Objects.equals(name, boundName)) {
            this.shaderBindings.put(binding, name);
            VeilRenderSystem.renderer().getShaderManager().setGlobal(shader -> shader.setUniformBlock(name, binding));
        }
    }

    public void unbind(ShaderBlock<?> block) {
        if (!(block instanceof ShaderBlockImpl)) {
            throw new UnsupportedOperationException("Cannot unbind " + block.getClass());
        }
        ShaderBlockImpl impl = (ShaderBlockImpl)block;
        Integer binding = this.boundBlocks.remove(block);
        if (binding != null) {
            this.unbind(binding, impl);
        }
    }

    private void unbind(int binding, ShaderBlockImpl<?> block) {
        block.unbind(binding);
        CharSequence name = this.shaderBindings.remove(binding);
        if (name != null) {
            VeilRenderSystem.renderer().getShaderManager().setGlobal(shader -> shader.setUniformBlock(name, 0));
        }
        if (binding < this.nextBinding) {
            this.nextBinding = binding;
        }
    }

    public void queueUpload() {
        this.shaderBindings.clear();
    }

    public void clear() {
        this.usedBindings.clear();
    }
}

