/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.deferred;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import java.util.Objects;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DeferredShaderStateCache {
    private ShaderInstance veil$oldShader;
    private ShaderInstance veil$deferredShader;

    public boolean setupRenderState(@Nullable ShaderInstance shaderInstance) {
        ShaderInstance shader = this.getShader(shaderInstance);
        if (shader != shaderInstance) {
            RenderSystem.setShader(() -> shader);
            return true;
        }
        return false;
    }

    @Contract(value="null -> null")
    public ShaderInstance getShader(ShaderInstance shaderInstance) {
        VeilDeferredRenderer deferredRenderer = VeilRenderSystem.renderer().getDeferredRenderer();
        if (shaderInstance == null || !deferredRenderer.isActive()) {
            this.veil$oldShader = null;
            this.veil$deferredShader = null;
            return shaderInstance;
        }
        if (!Objects.equals(this.veil$oldShader, shaderInstance)) {
            this.veil$oldShader = shaderInstance;
            ShaderProgram deferredShader = deferredRenderer.getDeferredShaderManager().getShader(new ResourceLocation(shaderInstance.getName()));
            this.veil$deferredShader = deferredShader != null ? deferredShader.toShaderInstance() : null;
        }
        return Objects.requireNonNullElse(this.veil$deferredShader, shaderInstance);
    }
}

