/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.imgui.CodeEditor;
import foundry.veil.api.client.imgui.VeilLanguageDefinitions;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.mixin.client.shader.GameRendererAccessor;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;

@ApiStatus.Internal
public class ShaderEditor
extends SingleWindowEditor
implements ResourceManagerReloadListener {
    private static final Pattern ERROR_PARSER = Pattern.compile("ERROR: (\\d+):(\\d+): (.+)");
    private static final Pattern LINE_DIRECTIVE_PARSER = Pattern.compile("#line\\s+(\\d+)\\s*(\\d+)?");
    private final CodeEditor codeEditor;
    private final Map<ResourceLocation, Integer> shaders = new TreeMap<ResourceLocation, Integer>();
    private final ImString programFilterText;
    private Pattern programFilter;
    private SelectedProgram selectedProgram;
    private int selectedTab;
    private final ImString addDefinitionText;
    private final Set<String> removedDefinitions;
    private final ImBoolean editSourceOpen;
    private int editProgramId;
    private int editShaderId;

    public ShaderEditor() {
        this.codeEditor = new CodeEditor("Upload");
        this.codeEditor.setSaveCallback((source, errorConsumer) -> {
            if (this.selectedProgram == null || !GL20C.glIsShader((int)this.editShaderId)) {
                errorConsumer.accept(0, "Invalid Shader");
                return;
            }
            GL20C.glShaderSource((int)this.editShaderId, (CharSequence)source);
            GL20C.glCompileShader((int)this.editShaderId);
            if (GL20C.glGetShaderi((int)this.editShaderId, (int)35713) != 1) {
                String log = GL20C.glGetShaderInfoLog((int)this.editShaderId);
                ShaderEditor.parseErrors(source, log).forEach(errorConsumer);
                System.out.println(log);
                return;
            }
            GL20C.glLinkProgram((int)this.editProgramId);
            if (GL20C.glGetProgrami((int)this.editProgramId, (int)35714) != 1) {
                String log = GL20C.glGetProgramInfoLog((int)this.editProgramId);
                ShaderEditor.parseErrors(source, log).forEach(errorConsumer);
                System.out.println(log);
            }
        });
        this.codeEditor.getEditor().setLanguageDefinition(VeilLanguageDefinitions.glsl());
        this.programFilterText = new ImString(128);
        this.programFilter = null;
        this.selectedProgram = null;
        this.selectedTab = 0;
        this.addDefinitionText = new ImString(128);
        this.removedDefinitions = new HashSet<String>(1);
        this.editSourceOpen = new ImBoolean();
        this.editProgramId = 0;
        this.editShaderId = 0;
    }

    private void setSelectedProgram(@Nullable ResourceLocation name) {
        if (name != null) {
            int program = this.shaders.get(name);
            if (GL20C.glIsProgram((int)program)) {
                int[] attachedShaders = new int[GL20C.glGetProgrami((int)program, (int)35717)];
                GL20C.glGetAttachedShaders((int)program, null, (int[])attachedShaders);
                Int2IntArrayMap shaders = new Int2IntArrayMap(attachedShaders.length);
                for (int shader : attachedShaders) {
                    shaders.put(GL20C.glGetShaderi((int)shader, (int)35663), shader);
                }
                this.selectedProgram = new SelectedProgram(name, program, Collections.unmodifiableMap(shaders));
                return;
            }
            System.out.println("Compiled shader does not exist for selected program.");
        }
        this.selectedProgram = null;
    }

    private void setEditShaderSource(int program, int shader) {
        this.editSourceOpen.set(true);
        this.editProgramId = program;
        this.editShaderId = shader;
        this.codeEditor.show(GL20C.glGetShaderSource((int)shader));
    }

    private static Map<Integer, String> parseErrors(String source, String log) {
        Map<Integer, Map<Integer, String>> logErrors = ShaderEditor.parseLogErrors(log);
        HashMap<Integer, String> foundErrors = new HashMap<Integer, String>();
        int sourceId = 0;
        int lineNumber = 0;
        int sourceLineNumber = -1;
        for (String line : source.split("\n")) {
            String error;
            ++sourceLineNumber;
            Matcher matcher = LINE_DIRECTIVE_PARSER.matcher(line);
            if (matcher.find()) {
                try {
                    lineNumber = Integer.parseInt(matcher.group(1));
                    if (matcher.groupCount() <= 1) continue;
                    sourceId = Integer.parseInt(matcher.group(2));
                }
                catch (Throwable throwable) {}
                continue;
            }
            Map<Integer, String> errors = logErrors.get(sourceId);
            if (errors != null && (error = errors.remove(lineNumber)) != null) {
                foundErrors.put(sourceLineNumber, error);
            }
            ++lineNumber;
        }
        return foundErrors;
    }

    private static Map<Integer, Map<Integer, String>> parseLogErrors(String log) {
        HashMap<Integer, Map<Integer, String>> logErrors = new HashMap<Integer, Map<Integer, String>>();
        for (String line : log.split("\n")) {
            Matcher matcher = ERROR_PARSER.matcher(line);
            if (!matcher.find()) continue;
            try {
                int sourceNumber = Integer.parseInt(matcher.group(1));
                int lineNumber = Integer.parseInt(matcher.group(2));
                Map errors = logErrors.computeIfAbsent(sourceNumber, unused -> new HashMap());
                if (errors.containsKey(lineNumber)) continue;
                String error = matcher.group(3);
                errors.put(lineNumber, error);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return logErrors;
    }

    private void reloadShaders() {
        this.shaders.clear();
        GameRendererAccessor gameRendererAccessor = (GameRendererAccessor)Minecraft.getInstance().gameRenderer;
        VeilRenderer veilRenderer = VeilRenderSystem.renderer();
        switch (TabSource.values()[this.selectedTab]) {
            case VANILLA: {
                for (ShaderInstance shaderInstance : gameRendererAccessor.getShaders().values()) {
                    String name = shaderInstance.getName().isBlank() ? Integer.toString(shaderInstance.getId()) : shaderInstance.getName();
                    this.shaders.put(new ResourceLocation(name), shaderInstance.getId());
                }
                break;
            }
            case VEIL: {
                for (ShaderProgram shaderProgram : veilRenderer.getShaderManager().getShaders().values()) {
                    this.shaders.put(shaderProgram.getId(), shaderProgram.getProgram());
                }
                break;
            }
            case VEIL_DEFERRED: {
                for (ShaderProgram shaderProgram : veilRenderer.getDeferredRenderer().getDeferredShaderManager().getShaders().values()) {
                    this.shaders.put(shaderProgram.getId(), shaderProgram.getProgram());
                }
                break;
            }
            case OTHER: {
                for (int i = 0; i < 10000; ++i) {
                    if (!GL20C.glIsProgram((int)i)) continue;
                    this.shaders.put(new ResourceLocation("unknown", Integer.toString(i)), i);
                }
                for (ShaderProgram shaderProgram : veilRenderer.getShaderManager().getShaders().values()) {
                    this.shaders.values().remove(shaderProgram.getProgram());
                }
                for (ShaderInstance shaderInstance : gameRendererAccessor.getShaders().values()) {
                    this.shaders.values().remove(shaderInstance.getId());
                }
                break;
            }
        }
        if (this.selectedProgram != null && !this.shaders.containsKey(this.selectedProgram.name)) {
            this.setSelectedProgram(null);
        }
    }

    @Override
    public String getDisplayName() {
        return "Shaders";
    }

    @Override
    protected void renderComponents() {
        this.removedDefinitions.clear();
        ImGui.beginChild("Shader Programs", ImGui.getContentRegionAvailX() * 2.0f / 3.0f, 0.0f);
        ImGui.text("Shader Programs");
        TabSource[] sources = TabSource.values();
        if (ImGui.beginTabBar("##controls")) {
            if (ImGui.tabItemButton("Refresh")) {
                this.reloadShaders();
            }
            for (TabSource source : sources) {
                ImGui.beginDisabled(!source.active.getAsBoolean());
                if (ImGui.beginTabItem(source.displayName)) {
                    if (this.selectedTab != source.ordinal()) {
                        this.selectedTab = source.ordinal();
                        this.setSelectedProgram(null);
                        this.reloadShaders();
                    }
                    ImGui.endTabItem();
                }
                ImGui.endDisabled();
            }
            ImGui.endTabBar();
        }
        while (!sources[this.selectedTab].active.getAsBoolean() && this.selectedTab > 0) {
            --this.selectedTab;
            this.setSelectedProgram(null);
            this.reloadShaders();
        }
        ImGui.setNextItemWidth(ImGui.getContentRegionAvailX());
        if (ImGui.inputTextWithHint("##search", "Search...", this.programFilterText)) {
            String regex = this.programFilterText.get();
            this.programFilter = null;
            if (!regex.isBlank()) {
                try {
                    this.programFilter = Pattern.compile(regex);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        }
        if (ImGui.beginListBox("##programs", ImGui.getContentRegionAvailX(), -1.4E-45f)) {
            for (ResourceLocation name : this.shaders.keySet()) {
                boolean selected;
                boolean bl = selected = this.selectedProgram != null && name.equals((Object)this.selectedProgram.name);
                if (this.programFilter != null && !this.programFilter.matcher(name.toString()).find()) {
                    if (!selected) continue;
                    this.setSelectedProgram(null);
                    continue;
                }
                if (!ImGui.selectable(name.toString(), selected)) continue;
                this.setSelectedProgram(name);
            }
            ImGui.endListBox();
        }
        ImGui.endChild();
        ShaderPreDefinitions definitions = VeilRenderSystem.renderer().getShaderDefinitions();
        ImGui.sameLine();
        if (ImGui.beginChild("Panel", 0.0f, ImGui.getContentRegionAvailY())) {
            if (ImGui.beginChild("Open Source", 0.0f, ImGui.getContentRegionAvailY() / 2.0f)) {
                ImGui.text("Open Source");
                this.openShaderButton("Vertex Shader", 35633);
                this.openShaderButton("Tesselation Control Shader", 36488);
                this.openShaderButton("Tesselation Evaluation Shader", 36487);
                this.openShaderButton("Geometry Shader", 36313);
                this.openShaderButton("Fragment Shader", 35632);
                this.openShaderButton("Compute Shader", 37305);
            }
            ImGui.endChild();
            if (ImGui.beginChild("Shader Definitions", 0.0f, ImGui.getContentRegionAvailY())) {
                ImGui.text("Shader Definitions:");
                ImGui.setNextItemWidth(ImGui.getContentRegionAvailX());
                if (ImGui.inputTextWithHint("##add_definition", "name = value", this.addDefinitionText, 32)) {
                    definitions.define(this.addDefinitionText.get().trim());
                    this.addDefinitionText.clear();
                }
                if (ImGui.beginListBox("##definitions", -1.4E-45f, ImGui.getContentRegionAvailY())) {
                    for (Map.Entry<String, String> entry : definitions.getDefinitions().entrySet()) {
                        String name = entry.getKey();
                        String value = entry.getValue();
                        ImGui.pushID(name);
                        ImGui.text(value);
                        float size = ImGui.getTextLineHeightWithSpacing();
                        ImGui.sameLine();
                        ImGui.dummy(ImGui.getContentRegionAvailX() - ImGui.getStyle().getCellPaddingX() * 2.0f - size, 0.0f);
                        ImGui.sameLine();
                        if (ImGui.button("X", size, size)) {
                            this.removedDefinitions.add(name);
                        }
                        ImGui.popID();
                    }
                    ImGui.endListBox();
                }
            }
            ImGui.endChild();
        }
        ImGui.endChild();
        for (String name : this.removedDefinitions) {
            definitions.remove(name);
        }
    }

    @Override
    public void render() {
        ImGui.setNextWindowSizeConstraints(600.0f, 400.0f, Float.MAX_VALUE, Float.MAX_VALUE);
        super.render();
        this.codeEditor.renderWindow();
    }

    private void openShaderButton(String name, int type) {
        ImGui.beginDisabled(this.selectedProgram == null || !this.selectedProgram.shaders.containsKey(type));
        if (ImGui.button(name)) {
            this.setEditShaderSource(this.selectedProgram.programId, this.selectedProgram.shaders.get(type));
        }
        ImGui.endDisabled();
    }

    @Override
    public void onShow() {
        super.onShow();
        this.reloadShaders();
    }

    @Override
    public void onHide() {
        super.onHide();
        this.shaders.clear();
    }

    @Override
    public void free() {
        super.free();
        this.codeEditor.free();
    }

    public void onResourceManagerReload(@NotNull ResourceManager resourceManager) {
        if (this.isOpen()) {
            this.reloadShaders();
        }
    }

    private record SelectedProgram(ResourceLocation name, int programId, Map<Integer, Integer> shaders) {
    }

    private static enum TabSource {
        VANILLA("Vanilla"),
        VEIL("Veil"),
        VEIL_DEFERRED("Veil Deferred", () -> VeilRenderSystem.renderer().getDeferredRenderer().isEnabled()),
        OTHER("Unknown");

        private final String displayName;
        private final BooleanSupplier active;

        private TabSource(String displayName) {
            this(displayName, () -> true);
        }

        private TabSource(String displayName, BooleanSupplier active) {
            this.displayName = displayName;
            this.active = active;
        }
    }
}

