/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.fabric.event.FabricVeilRenderLevelStageEvent;
import foundry.veil.mixin.client.deferred.RenderBuffersAccessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@ApiStatus.Internal
public class FabricRenderTypeStageHandler {
    private static final Map<VeilRenderLevelStageEvent.Stage, Set<RenderType>> STAGE_RENDER_TYPES = new HashMap<VeilRenderLevelStageEvent.Stage, Set<RenderType>>();

    public static void register(@Nullable VeilRenderLevelStageEvent.Stage stage, RenderType renderType) {
        SortedMap<RenderType, BufferBuilder> fixedBuffers = ((RenderBuffersAccessor)Minecraft.getInstance().renderBuffers()).getFixedBuffers();
        fixedBuffers.put(renderType, new BufferBuilder(renderType.bufferSize()));
        if (stage != null) {
            STAGE_RENDER_TYPES.computeIfAbsent(stage, unused -> new HashSet()).add(renderType);
        }
    }

    public static void renderStage(ProfilerFiller profiler, VeilRenderLevelStageEvent.Stage stage, LevelRenderer levelRenderer, MultiBufferSource.BufferSource bufferSource, PoseStack poseStack, Matrix4f projectionMatrix, int renderTick, float partialTicks, Camera camera, Frustum frustum) {
        profiler.push(stage.getName());
        ((VeilRenderLevelStageEvent)FabricVeilRenderLevelStageEvent.EVENT.invoker()).onRenderLevelStage(stage, levelRenderer, bufferSource, poseStack, projectionMatrix, renderTick, partialTicks, camera, frustum);
        profiler.pop();
        Set<RenderType> stages = STAGE_RENDER_TYPES.get((Object)stage);
        if (stages != null) {
            stages.forEach(arg_0 -> ((MultiBufferSource.BufferSource)bufferSource).endBatch(arg_0));
        }
    }
}

