/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric;

import foundry.veil.platform.registry.RegistrationProvider;
import foundry.veil.platform.registry.RegistryObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class FabricRegistrationFactory
implements RegistrationProvider.Factory {
    @Override
    public <T> RegistrationProvider<T> create(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        return new Provider(modId, resourceKey);
    }

    @Override
    public <T> RegistrationProvider<T> create(Registry<T> registry, String modId) {
        return new Provider<T>(modId, registry);
    }

    private static class Provider<T>
    implements RegistrationProvider<T> {
        private final String modId;
        private final Registry<T> registry;
        private final Set<RegistryObject<T>> entries = new HashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(String modId, ResourceKey<? extends Registry<T>> key) {
            this.modId = modId;
            Registry reg = (Registry)BuiltInRegistries.REGISTRY.get(key.location());
            if (reg == null) {
                throw new RuntimeException("Registry with name " + key.location() + " was not found!");
            }
            this.registry = reg;
        }

        private Provider(String modId, Registry<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        @Override
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            final ResourceLocation rl = new ResourceLocation(this.modId, name);
            if (this.registry.getOptional(rl).isPresent()) {
                return (RegistryObject)this.registry.get(rl);
            }
            final Object obj = Registry.register(this.registry, (ResourceLocation)rl, supplier.get());
            final ResourceKey key = ResourceKey.create((ResourceKey)this.registry.key(), (ResourceLocation)rl);
            RegistryObject ro = new RegistryObject<I>(){

                @Override
                public ResourceKey<I> getResourceKey() {
                    return key;
                }

                @Override
                public ResourceLocation getId() {
                    return rl;
                }

                @Override
                public I get() {
                    return obj;
                }

                @Override
                public Holder<I> asHolder() {
                    return registry.getHolder(key).orElse(null);
                }
            };
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Collection<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }

        @Override
        public String getModId() {
            return this.modId;
        }
    }
}

