/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.opencl;

import foundry.veil.api.opencl.CLBuffer;
import foundry.veil.api.opencl.CLEnvironment;
import foundry.veil.api.opencl.CLException;
import foundry.veil.api.opencl.CLMemObject;
import foundry.veil.api.opencl.VeilOpenCL;
import foundry.veil.lib.opencl.CL10;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.IntBuffer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeResource;

public class CLKernel
implements NativeResource {
    private final CLEnvironment environment;
    private final ResourceLocation program;
    private final long handle;
    private final int maxWorkGroupSize;
    private final LongSet pointers;

    CLKernel(CLEnvironment environment, ResourceLocation program, long handle) throws CLException {
        this.environment = environment;
        this.program = program;
        this.handle = handle;
        this.pointers = new LongArraySet();
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer work_group_loc = stack.mallocPointer(1);
            VeilOpenCL.checkCLError(CL10.clGetKernelWorkGroupInfo(this.handle, environment.getDevice().id(), 4528, work_group_loc, null));
            this.maxWorkGroupSize = (int)work_group_loc.get(0);
        }
    }

    public void execute(int globalWorkSize, int localWorkSize) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer global_work_size = stack.pointers((long)globalWorkSize);
            PointerBuffer local_work_size = stack.pointers((long)localWorkSize);
            VeilOpenCL.checkCLError(CL10.clEnqueueNDRangeKernel(this.environment.getCommandQueue(), this.handle, 1, null, global_work_size, local_work_size, null, null));
        }
    }

    public void execute(int globalWorkSizeX, int localWorkSizeX, int globalWorkSizeY, int localWorkSizeY) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer global_work_size = stack.pointers((long)globalWorkSizeX, (long)globalWorkSizeY);
            PointerBuffer local_work_size = stack.pointers((long)localWorkSizeX, (long)localWorkSizeY);
            VeilOpenCL.checkCLError(CL10.clEnqueueNDRangeKernel(this.environment.getCommandQueue(), this.handle, 2, null, global_work_size, local_work_size, null, null));
        }
    }

    public void execute(int globalWorkSizeX, int localWorkSizeX, int globalWorkSizeY, int localWorkSizeY, int globalWorkSizeZ, int localWorkSizeZ) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer global_work_size = stack.pointers((long)globalWorkSizeX, (long)globalWorkSizeY, (long)globalWorkSizeZ);
            PointerBuffer local_work_size = stack.pointers((long)localWorkSizeX, (long)localWorkSizeY, (long)localWorkSizeZ);
            VeilOpenCL.checkCLError(CL10.clEnqueueNDRangeKernel(this.environment.getCommandQueue(), this.handle, 3, null, global_work_size, local_work_size, null, null));
        }
    }

    public void execute(int[] globalWorkSizes, int[] localWorkSizes) throws CLException, IllegalArgumentException {
        if (globalWorkSizes.length != localWorkSizes.length) {
            throw new IllegalArgumentException("Global work size and local work size must have the same length");
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer global_work_size = stack.mallocPointer(globalWorkSizes.length);
            for (int i = 0; i < globalWorkSizes.length; ++i) {
                global_work_size.put(i, (long)globalWorkSizes[i]);
            }
            PointerBuffer local_work_size = stack.mallocPointer(localWorkSizes.length);
            for (int i = 0; i < localWorkSizes.length; ++i) {
                local_work_size.put(i, (long)localWorkSizes[i]);
            }
            VeilOpenCL.checkCLError(CL10.clEnqueueNDRangeKernel(this.environment.getCommandQueue(), this.handle, globalWorkSizes.length, null, global_work_size, local_work_size, null, null));
        }
    }

    @Nullable
    public CLBuffer createBufferUnsafe(int flags, long size) {
        try {
            return this.createBuffer(flags, size);
        }
        catch (CLException e) {
            VeilOpenCL.LOGGER.error("Failed to create CL buffer", (Throwable)e);
            return null;
        }
    }

    public CLBuffer createBuffer(int flags, long size) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer error_ret = stack.mallocInt(1);
            long pointer = CL10.clCreateBuffer(this.environment.getContext(), (long)flags, size, error_ret);
            VeilOpenCL.checkCLError(error_ret.get(0));
            this.pointers.add(pointer);
            CLBuffer cLBuffer = new CLBuffer(this, pointer);
            return cLBuffer;
        }
    }

    public void setByte(int index, byte value) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg1b(this.handle, index, value));
    }

    public void setShort(int index, short value) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg1s(this.handle, index, value));
    }

    public void setInt(int index, int value) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg1i(this.handle, index, value));
    }

    public void setLong(int index, long value) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg1l(this.handle, index, value));
    }

    public void setFloat(int index, float value) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg1f(this.handle, index, value));
    }

    public void setDouble(int index, double value) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg1d(this.handle, index, value));
    }

    public void setPointers(int index, long ... value) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer arg_value = stack.pointers(value);
            VeilOpenCL.checkCLError(CL10.clSetKernelArg(this.handle, index, arg_value));
        }
    }

    public void setPointers(int index, CLMemObject ... value) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer arg_value = stack.mallocPointer(value.length);
            for (CLMemObject object : value) {
                arg_value.put(object.pointer());
            }
            arg_value.rewind();
            VeilOpenCL.checkCLError(CL10.clSetKernelArg(this.handle, index, arg_value));
        }
    }

    public CLEnvironment getEnvironment() {
        return this.environment;
    }

    public ResourceLocation getProgram() {
        return this.program;
    }

    public long getHandle() {
        return this.handle;
    }

    public int getMaxWorkGroupSize() {
        return this.maxWorkGroupSize;
    }

    public void free() {
        CL10.clReleaseKernel(this.handle);
        this.pointers.forEach(CL10::clReleaseMemObject);
        this.pointers.clear();
        this.environment.free(this);
    }

    @ApiStatus.Internal
    void free(CLMemObject object) {
        long pointer = object.pointer();
        this.pointers.remove(pointer);
        CL10.clReleaseMemObject(pointer);
    }
}

