/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import com.mojang.blaze3d.platform.Window;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class SpaceHelper {
    public static Vector3f worldToScreenSpace(Vec3 pos, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPosition = camera.getPosition();
        Vector3f position = new Vector3f((float)(cameraPosition.x - pos.x), (float)(cameraPosition.y - pos.y), (float)(cameraPosition.z - pos.z));
        Quaternionf cameraRotation = camera.rotation();
        cameraRotation.conjugate();
        cameraRotation.transform(position);
        if (((Boolean)mc.options.bobView.get()).booleanValue() && mc.getCameraEntity() instanceof Player) {
            Player player = (Player)mc.getCameraEntity();
            float playerStep = player.walkDist - player.walkDistO;
            float stepSize = -(player.walkDist + playerStep * partialTicks);
            float viewBob = Mth.lerp((float)partialTicks, (float)player.oBob, (float)player.bob);
            Quaternionf bobXRotation = Axis.XP.rotationDegrees(Math.abs(Mth.cos((float)(stepSize * (float)Math.PI - 0.2f)) * viewBob) * 5.0f);
            Quaternionf bobZRotation = Axis.ZP.rotationDegrees(Mth.sin((float)(stepSize * (float)Math.PI)) * viewBob * 3.0f);
            bobXRotation.conjugate();
            bobZRotation.conjugate();
            bobXRotation.transform(position);
            bobZRotation.transform(position);
            position.add(Mth.sin((float)(stepSize * (float)Math.PI)) * viewBob * 0.5f, Math.abs(Mth.cos((float)(stepSize * (float)Math.PI)) * viewBob), 0.0f);
        }
        Window window = mc.getWindow();
        float screenSize = (float)window.getGuiScaledHeight() / 2.0f / position.z() / (float)Math.tan(Math.toRadians(mc.gameRenderer.getFov(camera, partialTicks, true) / 2.0));
        position.mul(-screenSize, -screenSize, 1.0f);
        position.add((float)window.getGuiScaledWidth() / 2.0f, (float)window.getGuiScaledHeight() / 2.0f, 0.0f);
        return position;
    }
}

