/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.program;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboTextureAttachment;
import foundry.veil.api.client.render.shader.program.ShaderUniformAccess;
import foundry.veil.api.client.render.shader.program.UniformAccess;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix2fc;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4fc;
import org.joml.Vector4ic;
import org.lwjgl.opengl.GL41C;
import org.lwjgl.system.MemoryStack;

public interface MutableShaderUniformAccess
extends UniformAccess,
ShaderUniformAccess {
    default public void applyRenderSystem() {
        this.setMatrix((CharSequence)"RenderModelViewMat", (Matrix4fc)RenderSystem.getModelViewMatrix());
        this.setMatrix((CharSequence)"RenderProjMat", (Matrix4fc)RenderSystem.getProjectionMatrix());
        float[] color = RenderSystem.getShaderColor();
        this.setVector("ColorModulator", color[0], color[1], color[2], color[3]);
        this.setFloat("GameTime", RenderSystem.getShaderGameTime());
    }

    default public void addRenderSystemTextures() {
        for (int i = 0; i < 12; ++i) {
            this.addSampler("Sampler" + i, RenderSystem.getShaderTexture((int)i));
        }
    }

    default public void setFramebufferSamplers(AdvancedFbo framebuffer) {
        int activeTexture = GlStateManager._getActiveTexture();
        for (int i = 0; i < framebuffer.getColorAttachments(); ++i) {
            if (!framebuffer.isColorTextureAttachment(i)) continue;
            AdvancedFboTextureAttachment attachment = framebuffer.getColorTextureAttachment(i);
            this.addSampler("DiffuseSampler" + i, attachment.getId());
            if (attachment.getName() == null) continue;
            this.addSampler(attachment.getName(), attachment.getId());
        }
        if (framebuffer.isDepthTextureAttachment()) {
            AdvancedFboTextureAttachment attachment = framebuffer.getDepthTextureAttachment();
            this.addSampler("DiffuseDepthSampler", framebuffer.getDepthTextureAttachment().getId());
            if (attachment.getName() != null) {
                this.addSampler(attachment.getName(), attachment.getId());
            }
        }
        RenderSystem.activeTexture((int)activeTexture);
    }

    public void addSampler(CharSequence var1, int var2);

    public void removeSampler(CharSequence var1);

    default public int applyShaderSamplers(int sampler) {
        return this.applyShaderSamplers(ShaderTextureSource.GLOBAL_CONTEXT, sampler);
    }

    public int applyShaderSamplers(@Nullable ShaderTextureSource.Context var1, int var2);

    public void clearSamplers();

    @Override
    default public void setUniformBlock(CharSequence name, int binding) {
        int index = this.getUniformBlock(name);
        if (index != -1) {
            GL41C.glUniformBlockBinding((int)this.getProgram(), (int)index, (int)binding);
        }
    }

    @Override
    default public void setFloat(CharSequence name, float value) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform1f((int)this.getProgram(), (int)location, (float)value);
        }
    }

    @Override
    default public void setVector(CharSequence name, float x, float y) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform2f((int)this.getProgram(), (int)location, (float)x, (float)y);
        }
    }

    @Override
    default public void setVector(CharSequence name, float x, float y, float z) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform3f((int)this.getProgram(), (int)location, (float)x, (float)y, (float)z);
        }
    }

    @Override
    default public void setVector(CharSequence name, float x, float y, float z, float w) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform4f((int)this.getProgram(), (int)location, (float)x, (float)y, (float)z, (float)w);
        }
    }

    @Override
    default public void setInt(CharSequence name, int value) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform1i((int)this.getProgram(), (int)location, (int)value);
        }
    }

    @Override
    default public void setVectorI(CharSequence name, int x, int y) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform2i((int)this.getProgram(), (int)location, (int)x, (int)y);
        }
    }

    @Override
    default public void setVectorI(CharSequence name, int x, int y, int z) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform3i((int)this.getProgram(), (int)location, (int)x, (int)y, (int)z);
        }
    }

    @Override
    default public void setVectorI(CharSequence name, int x, int y, int z, int w) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform4i((int)this.getProgram(), (int)location, (int)x, (int)y, (int)z, (int)w);
        }
    }

    @Override
    default public void setFloats(CharSequence name, float ... values) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform1fv((int)this.getProgram(), (int)location, (float[])values);
        }
    }

    @Override
    default public void setVectors(CharSequence name, Vector2fc ... values) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length * 2);
            for (int i = 0; i < values.length; ++i) {
                values[i].get(i * 2, buffer);
            }
            GL41C.glProgramUniform2fv((int)this.getProgram(), (int)location, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setVectors(CharSequence name, Vector3fc ... values) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length * 3);
            for (int i = 0; i < values.length; ++i) {
                values[i].get(i * 3, buffer);
            }
            GL41C.glProgramUniform3fv((int)this.getProgram(), (int)location, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setVectors(CharSequence name, Vector4fc ... values) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(values.length * 4);
            for (int i = 0; i < values.length; ++i) {
                values[i].get(i * 4, buffer);
            }
            GL41C.glProgramUniform4fv((int)this.getProgram(), (int)location, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setInts(CharSequence name, int ... values) {
        int location = this.getUniform(name);
        if (location != -1) {
            GL41C.glProgramUniform1iv((int)this.getProgram(), (int)location, (int[])values);
        }
    }

    @Override
    default public void setVectors(CharSequence name, Vector2ic ... values) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length * 2);
            for (int i = 0; i < values.length; ++i) {
                values[i].get(i * 2, buffer);
            }
            GL41C.glProgramUniform2iv((int)this.getProgram(), (int)location, (IntBuffer)buffer);
        }
    }

    @Override
    default public void setVectors(CharSequence name, Vector3ic ... values) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length * 3);
            for (int i = 0; i < values.length; ++i) {
                values[i].get(i * 3, buffer);
            }
            GL41C.glProgramUniform3iv((int)this.getProgram(), (int)location, (IntBuffer)buffer);
        }
    }

    @Override
    default public void setVectors(CharSequence name, Vector4ic ... values) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer buffer = stack.mallocInt(values.length * 4);
            for (int i = 0; i < values.length; ++i) {
                values[i].get(i * 4, buffer);
            }
            GL41C.glProgramUniform4iv((int)this.getProgram(), (int)location, (IntBuffer)buffer);
        }
    }

    @Override
    default public void setMatrix(CharSequence name, Matrix2fc value) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(4);
            value.get(buffer);
            GL41C.glProgramUniformMatrix2fv((int)this.getProgram(), (int)location, (boolean)false, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setMatrix(CharSequence name, Matrix3fc value) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(9);
            value.get(buffer);
            GL41C.glProgramUniformMatrix3fv((int)this.getProgram(), (int)location, (boolean)false, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setMatrix(CharSequence name, Matrix3x2fc value) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(6);
            value.get(buffer);
            GL41C.glProgramUniformMatrix3x2fv((int)this.getProgram(), (int)location, (boolean)false, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setMatrix(CharSequence name, Matrix4fc value) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(16);
            value.get(buffer);
            GL41C.glProgramUniformMatrix4fv((int)this.getProgram(), (int)location, (boolean)false, (FloatBuffer)buffer);
        }
    }

    @Override
    default public void setMatrix(CharSequence name, Matrix4x3fc value) {
        int location = this.getUniform(name);
        if (location == -1) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(12);
            value.get(buffer);
            GL41C.glProgramUniformMatrix4x3fv((int)this.getProgram(), (int)location, (boolean)false, (FloatBuffer)buffer);
        }
    }
}

