/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.processor;

import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;

public class ShaderImportProcessor
implements ShaderPreProcessor {
    private static final String INCLUDE_KEY = "#include ";
    private final ResourceProvider resourceProvider;
    private final Set<ResourceLocation> addedImports;
    private final Map<ResourceLocation, String> imports;
    private final List<ResourceLocation> importOrder;

    public ShaderImportProcessor(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
        this.addedImports = new HashSet<ResourceLocation>();
        this.imports = new HashMap<ResourceLocation, String>();
        this.importOrder = new ArrayList<ResourceLocation>();
    }

    @Override
    public void prepare() {
        this.addedImports.clear();
    }

    @Override
    public String modify(ShaderPreProcessor.Context context) throws IOException {
        List<String> inputLines = context.getInput().lines().toList();
        LinkedList<Object> output = new LinkedList<Object>();
        for (String line : inputLines) {
            if (!line.startsWith(INCLUDE_KEY)) {
                output.add(line);
                continue;
            }
            try {
                String trimmedImport = line.substring(INCLUDE_KEY.length()).trim();
                ResourceLocation source = new ResourceLocation(trimmedImport);
                if (!this.addedImports.add(source)) continue;
                try {
                    String importString;
                    if (!this.imports.containsKey(source)) {
                        this.imports.put(source, this.loadImport(source));
                        this.importOrder.add(source);
                    }
                    if ((importString = this.imports.get(source)) == null) {
                        throw new IOException("Import previously failed to load");
                    }
                    long lineNumber = String.join((CharSequence)"\n", output).lines().filter(s -> !s.startsWith("#line")).count() + 2L;
                    int sourceNumber = this.importOrder.indexOf(source);
                    output.add("#line 0 " + (sourceNumber + 1));
                    output.add(context.modify(source, importString));
                    output.add("#line " + lineNumber + " " + sourceNumber);
                }
                catch (Exception e) {
                    throw new IOException("Failed to add import: " + line, e);
                }
            }
            catch (ResourceLocationException e) {
                throw new IOException("Invalid import: " + line, e);
            }
        }
        return String.join((CharSequence)"\n", output);
    }

    private String loadImport(ResourceLocation source) throws IOException {
        Resource resource = this.resourceProvider.getResourceOrThrow(ShaderManager.INCLUDE_LISTER.idToFile(source));
        try (BufferedReader reader = resource.openAsReader();){
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
    }
}

