/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.definition;

import foundry.veil.api.client.render.shader.definition.DynamicShaderBlock;
import foundry.veil.impl.client.render.shader.definition.DynamicShaderBlockImpl;
import foundry.veil.impl.client.render.shader.definition.SizedShaderBlockImpl;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public interface ShaderBlock<T>
extends NativeResource {
    public static <T> ShaderBlock<T> withSize(int size, BiConsumer<T, ByteBuffer> serializer) {
        return new SizedShaderBlockImpl<T>(size, serializer);
    }

    public static <T> DynamicShaderBlock<T> dynamic(BiConsumer<T, ByteBuffer> serializer) {
        return ShaderBlock.dynamic(256, serializer);
    }

    public static <T> DynamicShaderBlock<T> dynamic(int initialSize, BiConsumer<T, ByteBuffer> serializer) {
        return new DynamicShaderBlockImpl<T>(initialSize, serializer);
    }

    default public void update(@Nullable T value) {
        if (!Objects.equals(this.getValue(), value)) {
            this.set(value);
        }
    }

    public void set(@Nullable T var1);

    @Nullable
    public T getValue();
}

