/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.post;

import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.VeilClient;
import foundry.veil.api.CodecReloadListener;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.post.stage.CompositePostPipeline;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.pipeline.PostPipelineContext;
import foundry.veil.platform.services.VeilClientPlatform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;
import org.slf4j.Logger;

public class PostProcessingManager
extends CodecReloadListener<CompositePostPipeline>
implements NativeResource {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Comparator<ProfileEntry> PIPELINE_SORTER = Comparator.comparingInt(ProfileEntry::getPriority).reversed();
    private final PostPipelineContext context = new PostPipelineContext();
    private final List<ProfileEntry> activePipelines = new LinkedList<ProfileEntry>();
    private final Map<ResourceLocation, PostPipeline> pipelines = new HashMap<ResourceLocation, PostPipeline>();

    public PostProcessingManager() {
        super(CompositePostPipeline.CODEC, FileToIdConverter.json((String)"pinwheel/post"));
    }

    public boolean isActive(ResourceLocation pipeline) {
        return this.activePipelines.stream().anyMatch(entry -> entry.pipeline.equals((Object)pipeline));
    }

    public boolean add(ResourceLocation pipeline) {
        return this.add(1000, pipeline);
    }

    public boolean add(int priority, ResourceLocation pipeline) {
        if (this.activePipelines.stream().anyMatch(entry -> entry.priority == priority && entry.pipeline.equals((Object)pipeline))) {
            return false;
        }
        this.remove(pipeline);
        this.activePipelines.add(new ProfileEntry(pipeline, priority));
        this.activePipelines.sort(PIPELINE_SORTER);
        return true;
    }

    public boolean remove(ResourceLocation pipeline) {
        return this.activePipelines.removeIf(entry -> entry.pipeline.equals((Object)pipeline));
    }

    @Nullable
    public PostPipeline getPipeline(ResourceLocation pipeline) {
        return this.pipelines.get(pipeline);
    }

    private void setup() {
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
    }

    private void clear() {
        ShaderProgram.unbind();
        AdvancedFbo.unbind();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
    }

    private void clearPipeline() {
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public void runPipeline() {
        if (this.activePipelines.isEmpty()) {
            return;
        }
        VeilClientPlatform platform = VeilClient.clientPlatform();
        this.context.begin();
        this.setup();
        int activeTexture = GlStateManager._getActiveTexture();
        this.activePipelines.sort(PIPELINE_SORTER);
        for (ProfileEntry entry : this.activePipelines) {
            ResourceLocation id = entry.getPipeline();
            PostPipeline pipeline = this.pipelines.get(id);
            if (pipeline == null) continue;
            platform.preVeilPostProcessing(id, pipeline, this.context);
            try {
                pipeline.apply(this.context);
                this.clearPipeline();
            }
            catch (Exception e) {
                LOGGER.error("Error running pipeline {}", (Object)id, (Object)e);
            }
            platform.postVeilPostProcessing(id, pipeline, this.context);
        }
        RenderSystem.activeTexture((int)activeTexture);
        this.clear();
        this.context.end();
    }

    public void runPipeline(PostPipeline pipeline) {
        this.context.begin();
        this.setup();
        int activeTexture = GlStateManager._getActiveTexture();
        try {
            pipeline.apply(this.context);
            this.clearPipeline();
        }
        catch (Exception e) {
            LOGGER.error("Error running pipeline {}", (Object)pipeline, (Object)e);
        }
        RenderSystem.activeTexture((int)activeTexture);
        this.clear();
        this.context.end();
    }

    private CompositePostPipeline loadPipeline(Resource resource) throws IOException {
        try (BufferedReader reader = resource.openAsReader();){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            DataResult result = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (result.error().isPresent()) {
                throw new JsonSyntaxException(((DataResult.PartialResult)result.error().get()).message());
            }
            CompositePostPipeline compositePostPipeline = (CompositePostPipeline)result.result().orElseThrow();
            return compositePostPipeline;
        }
    }

    @Override
    @NotNull
    protected Map<ResourceLocation, CompositePostPipeline> prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, CompositePostPipeline> data = new HashMap<ResourceLocation, CompositePostPipeline>();
        Map resources = this.converter.listMatchingResourceStacks(resourceManager);
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            ResourceLocation id = this.converter.fileToId(location);
            if (((List)entry.getValue()).size() == 1) {
                try {
                    data.put(id, this.loadPipeline((Resource)Iterables.getOnlyElement((Iterable)((Iterable)entry.getValue()))));
                }
                catch (Exception e) {
                    this.logger.error("Couldn't parse data file {} from {}", new Object[]{id, location, e});
                }
                continue;
            }
            List<CompositePostPipeline> pipelines = new ArrayList<CompositePostPipeline>(((List)entry.getValue()).size());
            for (Resource resource : (List)entry.getValue()) {
                try {
                    pipelines.add(this.loadPipeline(resource));
                }
                catch (Exception e) {
                    this.logger.error("Couldn't parse data file {} from {}", new Object[]{id, location, e});
                }
            }
            if (pipelines.isEmpty()) continue;
            if (pipelines.size() == 1) {
                data.put(id, (CompositePostPipeline)Iterables.getOnlyElement(pipelines));
                continue;
            }
            pipelines.sort(Comparator.comparingInt(CompositePostPipeline::getPriority));
            for (int i = 0; i < pipelines.size(); ++i) {
                CompositePostPipeline pipeline = (CompositePostPipeline)pipelines.get(i);
                if (!pipeline.isReplace()) continue;
                pipelines = pipelines.subList(0, i + 1);
                break;
            }
            data.put(id, new CompositePostPipeline((PostPipeline[])pipelines.toArray(CompositePostPipeline[]::new), Collections.emptyMap(), Collections.emptyMap()));
        }
        return data;
    }

    protected void apply(@NotNull Map<ResourceLocation, CompositePostPipeline> data, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        this.pipelines.values().forEach(PostPipeline::free);
        this.pipelines.clear();
        this.pipelines.putAll(data);
        LOGGER.info("Loaded {} post pipelines", (Object)this.pipelines.size());
    }

    public void free() {
        this.pipelines.values().forEach(PostPipeline::free);
        this.pipelines.clear();
        this.context.free();
    }

    public PostPipeline.Context getContext() {
        return this.context;
    }

    @NotNull
    public Set<ResourceLocation> getPipelines() {
        return this.pipelines.keySet();
    }

    public List<ProfileEntry> getActivePipelines() {
        this.activePipelines.sort(PIPELINE_SORTER);
        return this.activePipelines;
    }

    public static class ProfileEntry {
        private final ResourceLocation pipeline;
        private int priority;

        public ProfileEntry(ResourceLocation pipeline, int priority) {
            this.pipeline = pipeline;
            this.priority = priority;
        }

        public ResourceLocation getPipeline() {
            return this.pipeline;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProfileEntry that = (ProfileEntry)o;
            return this.priority == that.priority && Objects.equals(this.pipeline, that.pipeline);
        }

        public int hashCode() {
            int result = this.pipeline.hashCode();
            result = 31 * result + this.priority;
            return result;
        }
    }
}

