/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import foundry.veil.api.CodecReloadListener;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferDefinition;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.NativeResource;
import org.slf4j.Logger;

public class FramebufferManager
extends CodecReloadListener<FramebufferDefinition>
implements NativeResource {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation MAIN = new ResourceLocation("main");
    public static final Codec<ResourceLocation> FRAMEBUFFER_CODEC = Codec.STRING.comapFlatMap(name -> {
        try {
            if (!name.contains(":")) {
                return DataResult.success((Object)new ResourceLocation("temp", name));
            }
            return DataResult.success((Object)new ResourceLocation(name));
        }
        catch (ResourceLocationException e) {
            return DataResult.error(() -> "Not a valid resource location: " + name + ". " + e.getMessage());
        }
    }, location -> "temp".equals(location.getNamespace()) ? location.getPath() : location.toString()).stable();
    private final Map<ResourceLocation, FramebufferDefinition> framebufferDefinitions = new HashMap<ResourceLocation, FramebufferDefinition>();
    private final Map<ResourceLocation, AdvancedFbo> framebuffers = new HashMap<ResourceLocation, AdvancedFbo>();
    private final Map<ResourceLocation, AdvancedFbo> framebuffersView = Collections.unmodifiableMap(this.framebuffers);

    public FramebufferManager() {
        super(FramebufferDefinition.CODEC, FileToIdConverter.json((String)"pinwheel/framebuffers"));
    }

    @ApiStatus.Internal
    public void resizeFramebuffers(int width, int height) {
        this.free();
        MolangRuntime runtime = (MolangRuntime)MolangRuntime.runtime().setQuery("screen_width", width).setQuery("screen_height", height).create();
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.framebufferDefinitions.forEach((name, definition) -> {
            try {
                AdvancedFbo fbo = definition.createBuilder(runtime).build(true);
                fbo.bindDraw(false);
                fbo.clear();
                this.framebuffers.put((ResourceLocation)name, fbo);
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize framebuffer: {}", name, (Object)e);
            }
        });
        AdvancedFbo.unbind();
        this.framebuffers.put(MAIN, AdvancedFbo.getMainFramebuffer());
    }

    @ApiStatus.Internal
    public void clear() {
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.framebuffers.forEach((name, fbo) -> {
            if (MAIN.equals(name)) {
                return;
            }
            fbo.bindDraw(false);
            fbo.clear();
        });
        GL30.glBindFramebuffer((int)36160, (int)0);
    }

    @Nullable
    public AdvancedFbo getFramebuffer(ResourceLocation name) {
        return this.framebuffers.get(name);
    }

    public Map<ResourceLocation, AdvancedFbo> getFramebuffers() {
        return this.framebuffersView;
    }

    protected void apply(@NotNull Map<ResourceLocation, FramebufferDefinition> data, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        this.framebufferDefinitions.clear();
        this.framebufferDefinitions.putAll(data);
        Window window = Minecraft.getInstance().getWindow();
        this.resizeFramebuffers(window.getWidth(), window.getHeight());
        LOGGER.info("Loaded {} framebuffers", (Object)this.framebufferDefinitions.size());
    }

    public void free() {
        this.framebuffers.remove(MAIN);
        this.framebuffers.values().forEach(NativeResource::free);
        this.framebuffers.clear();
    }
}

